/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.CorrelationView;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.List;

public class CorrelationViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    private int streamNumber;
    protected ExprNode expressionX;
    protected ExprNode expressionY;
    protected StatViewAdditionalProps additionalProps;
    protected EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        this.streamNumber = viewFactoryContext.getStreamNum();
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Correlation view", parentEventType, statementContext, this.viewParameters, true);
        String errorMessage = "Correlation view requires two expressions providing x and y values as properties";
        if (validated.length < 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getExprEvaluator().getType()) || !JavaClassHelper.isNumeric(validated[1].getExprEvaluator().getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.expressionX = validated[0];
        this.expressionY = validated[1];
        this.additionalProps = StatViewAdditionalProps.make(validated, 2, parentEventType);
        this.eventType = CorrelationView.createEventType(statementContext, this.additionalProps, this.streamNumber);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new CorrelationView(agentInstanceViewFactoryContext.getAgentInstanceContext(), this.expressionX, this.expressionY, this.eventType, this.additionalProps);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof CorrelationView)) {
            return false;
        }
        if (this.additionalProps != null) {
            return false;
        }
        CorrelationView other = (CorrelationView)view;
        return ExprNodeUtility.deepEquals(other.getExpressionX(), this.expressionX) && ExprNodeUtility.deepEquals(other.getExpressionY(), this.expressionY);
    }
}

