/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.BaseStatisticsBean;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.HashMap;
import java.util.Iterator;

public class UnivariateStatisticsView
extends ViewSupport
implements CloneableView {
    protected final AgentInstanceContext agentInstanceContext;
    private final EventType eventType;
    private final ExprNode fieldExpression;
    private final ExprEvaluator fieldExpressionEvaluator;
    protected final BaseStatisticsBean baseStatisticsBean = new BaseStatisticsBean();
    protected final StatViewAdditionalProps additionalProps;
    private EventBean lastNewEvent;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected Object[] lastValuesEventNew;

    public UnivariateStatisticsView(AgentInstanceContext agentInstanceContext, ExprNode fieldExpression, EventType eventType, StatViewAdditionalProps additionalProps) {
        this.agentInstanceContext = agentInstanceContext;
        this.fieldExpression = fieldExpression;
        this.fieldExpressionEvaluator = fieldExpression.getExprEvaluator();
        this.eventType = eventType;
        this.additionalProps = additionalProps;
    }

    @Override
    public View cloneView() {
        return new UnivariateStatisticsView(this.agentInstanceContext, this.fieldExpression, this.eventType, this.additionalProps);
    }

    public final ExprNode getFieldExpression() {
        return this.fieldExpression;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double point;
        Number pointnum;
        int i;
        EventBean oldDataMap = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                pointnum = (Number)this.fieldExpressionEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null) continue;
                point = pointnum.doubleValue();
                this.baseStatisticsBean.addPoint(point, 0.0);
            }
            if (this.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.additionalProps.getAdditionalExpr().length];
                }
                for (int val = 0; val < this.additionalProps.getAdditionalExpr().length; ++val) {
                    this.lastValuesEventNew[val] = this.additionalProps.getAdditionalExpr()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                pointnum = (Number)this.fieldExpressionEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (pointnum == null) continue;
                point = pointnum.doubleValue();
                this.baseStatisticsBean.removePoint(point, 0.0);
            }
        }
        if (this.hasViews()) {
            EventBean newDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew);
            if (this.lastNewEvent == null) {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{oldDataMap});
            } else {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataMap;
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldExpression=" + this.fieldExpression;
    }

    public static EventBean populateMap(BaseStatisticsBean baseStatisticsBean, EventAdapterService eventAdapterService, EventType eventType, StatViewAdditionalProps additionalProps, Object[] lastNewValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS.getName(), baseStatisticsBean.getN());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL.getName(), baseStatisticsBean.getXSum());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), baseStatisticsBean.getXStandardDeviationSample());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), baseStatisticsBean.getXStandardDeviationPop());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), baseStatisticsBean.getXVariance());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), baseStatisticsBean.getXAverage());
        if (additionalProps != null) {
            additionalProps.addProperties(result, lastNewValues);
        }
        return eventAdapterService.adapterForTypedMap(result, eventType);
    }

    public static EventType createEventType(StatementContext statementContext, StatViewAdditionalProps additionalProps, int streamNum) {
        HashMap<String, Object> eventTypeMap = new HashMap<String, Object>();
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS.getName(), Long.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), Double.class);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), Double.class);
        StatViewAdditionalProps.addCheckDupProperties(eventTypeMap, additionalProps, ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS, ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL, ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV, ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA, ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE, ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE);
        String outputEventTypeName = statementContext.getStatementId() + "_statview_" + streamNum;
        return statementContext.getEventAdapterService().createAnonymousMapType(outputEventTypeName, eventTypeMap);
    }

    public BaseStatisticsBean getBaseStatisticsBean() {
        return this.baseStatisticsBean;
    }

    public Object[] getLastValuesEventNew() {
        return this.lastValuesEventNew;
    }

    public void setLastValuesEventNew(Object[] lastValuesEventNew) {
        this.lastValuesEventNew = lastValuesEventNew;
    }
}

