/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import com.espertech.esper.view.stat.WeightedAverageView;
import java.util.List;

public class WeightedAverageViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    private int streamNumber;
    protected ExprNode fieldNameX;
    protected ExprNode fieldNameWeight;
    protected StatViewAdditionalProps additionalProps;
    protected EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        this.streamNumber = viewFactoryContext.getStreamNum();
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Weighted average view", parentEventType, statementContext, this.viewParameters, true);
        String errorMessage = "Weighted average view requires two expressions returning numeric values as parameters";
        if (validated.length < 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getExprEvaluator().getType()) || !JavaClassHelper.isNumeric(validated[1].getExprEvaluator().getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.fieldNameX = validated[0];
        this.fieldNameWeight = validated[1];
        this.additionalProps = StatViewAdditionalProps.make(validated, 2, parentEventType);
        this.eventType = WeightedAverageView.createEventType(statementContext, this.additionalProps, this.streamNumber);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new WeightedAverageView(agentInstanceViewFactoryContext.getAgentInstanceContext(), this.fieldNameX, this.fieldNameWeight, this.eventType, this.additionalProps);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof WeightedAverageView)) {
            return false;
        }
        if (this.additionalProps != null) {
            return false;
        }
        WeightedAverageView myView = (WeightedAverageView)view;
        return ExprNodeUtility.deepEquals(this.fieldNameWeight, myView.getFieldNameWeight()) && ExprNodeUtility.deepEquals(this.fieldNameX, myView.getFieldNameX());
    }
}

