/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FirstUniqueByPropertyView
extends ViewSupport
implements CloneableView {
    private final ExprNode[] uniqueCriteria;
    protected final ExprEvaluator[] uniqueCriteriaEval;
    private final int numKeys;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected final Map<Object, EventBean> firstEvents = new LinkedHashMap<Object, EventBean>();
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private static final Log log = LogFactory.getLog(FirstUniqueByPropertyView.class);

    public FirstUniqueByPropertyView(ExprNode[] uniqueCriteria, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.uniqueCriteria = uniqueCriteria;
        this.uniqueCriteriaEval = ExprNodeUtility.getEvaluators(uniqueCriteria);
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.numKeys = uniqueCriteria.length;
    }

    @Override
    public View cloneView() {
        return new FirstUniqueByPropertyView(this.uniqueCriteria, this.agentInstanceViewFactoryContext);
    }

    public final ExprNode[] getUniqueCriteria() {
        return this.uniqueCriteria;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        Object key;
        EventBean[] newDataToPost = null;
        EventBean[] oldDataToPost = null;
        if (oldData != null) {
            for (EventBean oldEvent : oldData) {
                key = this.getUniqueKey(oldEvent);
                EventBean lastValue = this.firstEvents.get(key);
                if (lastValue != oldEvent) continue;
                oldDataToPost = oldDataToPost == null ? new EventBean[]{oldEvent} : EventBeanUtility.addToArray(oldDataToPost, oldEvent);
                this.firstEvents.remove(key);
                this.internalHandleRemoved(key, lastValue);
            }
        }
        if (newData != null) {
            for (EventBean newEvent : newData) {
                key = this.getUniqueKey(newEvent);
                if (this.firstEvents.containsKey(key)) continue;
                this.firstEvents.put(key, newEvent);
                this.internalHandleAdded(key, newEvent);
                newDataToPost = newDataToPost == null ? new EventBean[]{newEvent} : EventBeanUtility.addToArray(newDataToPost, newEvent);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            this.updateChildren(newDataToPost, oldDataToPost);
        }
    }

    public void internalHandleRemoved(Object key, EventBean lastValue) {
    }

    public void internalHandleAdded(Object key, EventBean newEvent) {
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.firstEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueCriteria=" + Arrays.toString(this.uniqueCriteria);
    }

    protected Object getUniqueKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.numKeys == 1) {
            return this.uniqueCriteriaEval[0].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        Object[] values = new Object[this.numKeys];
        for (int i = 0; i < this.numKeys; ++i) {
            values[i] = this.uniqueCriteriaEval[i].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        return new MultiKeyUntyped(values);
    }

    public boolean isEmpty() {
        return this.firstEvents.isEmpty();
    }
}

