/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.AddPropertyValueView;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.MergeView;
import com.espertech.esper.view.std.MergeViewMarker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupByViewImpl
extends ViewSupport
implements CloneableView,
GroupByView {
    private final ExprNode[] criteriaExpressions;
    private final ExprEvaluator[] criteriaEvaluators;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected String[] propertyNames;
    protected final Map<Object, Object> subViewsPerKey = new HashMap<Object, Object>();
    private final HashMap<Object, Pair<Object, Object>> groupedEvents = new HashMap();
    private static final Log log = LogFactory.getLog(GroupByViewImpl.class);

    public GroupByViewImpl(AgentInstanceViewFactoryChainContext agentInstanceContext, ExprNode[] criteriaExpressions, ExprEvaluator[] criteriaEvaluators) {
        this.agentInstanceContext = agentInstanceContext;
        this.criteriaExpressions = criteriaExpressions;
        this.criteriaEvaluators = criteriaEvaluators;
        this.propertyNames = new String[criteriaExpressions.length];
        for (int i = 0; i < criteriaExpressions.length; ++i) {
            this.propertyNames[i] = criteriaExpressions[i].toExpressionString();
        }
    }

    @Override
    public View cloneView() {
        return new GroupByViewImpl(this.agentInstanceContext, this.criteriaExpressions, this.criteriaEvaluators);
    }

    @Override
    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            EventBean[] newDataToPost = new EventBean[]{theEvent};
            Object groupByValuesKey = this.getGroupKey(theEvent);
            Object subViews = this.subViewsPerKey.get(groupByValuesKey);
            if (subViews == null) {
                subViews = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey, this.agentInstanceContext);
                this.subViewsPerKey.put(groupByValuesKey, subViews);
            }
            GroupByViewImpl.updateChildViews(subViews, newDataToPost, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry<Object, Pair<Object, Object>> entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(entry.getValue().getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(entry.getValue().getSecond());
                GroupByViewImpl.updateChildViews(entry.getKey(), newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.criteriaExpressions);
    }

    public static Object makeSubViews(GroupByView groupView, String[] propertyNames, Object groupByValues, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        Iterable<View> subviewHolder;
        if (!groupView.hasViews()) {
            String message = "Unexpected empty list of child nodes for group view";
            log.fatal((Object)(".copySubViews " + message));
            throw new EPException(message);
        }
        if (groupView.getViews().length == 1) {
            subviewHolder = GroupByViewImpl.copyChildView(groupView, propertyNames, groupByValues, agentInstanceContext, groupView.getViews()[0]);
        } else {
            ArrayList<View> subViewList;
            subviewHolder = subViewList = new ArrayList<View>(4);
            for (View originalChildView : groupView.getViews()) {
                View copyChildView = GroupByViewImpl.copyChildView(groupView, propertyNames, groupByValues, agentInstanceContext, originalChildView);
                subViewList.add(copyChildView);
            }
        }
        return subviewHolder;
    }

    protected static void updateChildViews(Object subViews, EventBean[] newData, EventBean[] oldData) {
        if (subViews instanceof List) {
            List viewList = (List)subViews;
            ViewSupport.updateChildren(viewList, newData, oldData);
        } else {
            ((View)subViews).update(newData, oldData);
        }
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Pair<Object, Object> pair;
        Object groupByValuesKey = this.getGroupKey(theEvent);
        Object subViews = this.subViewsPerKey.get(groupByValuesKey);
        if (subViews == null) {
            subViews = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey, this.agentInstanceContext);
            this.subViewsPerKey.put(groupByValuesKey, subViews);
        }
        if ((pair = this.groupedEvents.get(subViews)) == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    private static View copyChildView(GroupByView groupView, String[] propertyNames, Object groupByValues, AgentInstanceViewFactoryChainContext agentInstanceContext, View originalChildView) {
        if (originalChildView instanceof MergeView) {
            String message = "Unexpected merge view as child of group-by view";
            log.fatal((Object)(".copySubViews " + message));
            throw new EPException(message);
        }
        if (!(originalChildView instanceof CloneableView)) {
            throw new EPException("Unexpected error copying subview " + originalChildView.getClass().getName());
        }
        CloneableView cloneableView = (CloneableView)((Object)originalChildView);
        View copyChildView = cloneableView.cloneView();
        copyChildView.setParent(groupView);
        GroupByViewImpl.copySubViews(groupView.getCriteriaExpressions(), propertyNames, groupByValues, originalChildView, copyChildView, agentInstanceContext);
        return copyChildView;
    }

    private static void copySubViews(ExprNode[] criteriaExpressions, String[] propertyNames, Object groupByValues, View originalView, View copyView, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        for (View subView : originalView.getViews()) {
            MergeViewMarker mergeView;
            if (subView instanceof MergeViewMarker && ExprNodeUtility.deepEquals((mergeView = (MergeViewMarker)subView).getGroupFieldNames(), criteriaExpressions)) {
                AddPropertyValueView mergeDataView = new AddPropertyValueView(agentInstanceContext, propertyNames, groupByValues, mergeView.getEventType());
                copyView.addView(mergeDataView);
                mergeDataView.addView(mergeView);
                mergeView.addParentView(mergeDataView);
                continue;
            }
            if (!(subView instanceof CloneableView)) {
                throw new EPException("Unexpected error copying subview");
            }
            CloneableView cloneableView = (CloneableView)((Object)subView);
            View copiedChild = cloneableView.cloneView();
            copyView.addView(copiedChild);
            GroupByViewImpl.copySubViews(criteriaExpressions, propertyNames, groupByValues, subView, copiedChild, agentInstanceContext);
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.criteriaEvaluators.length == 1) {
            return this.criteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        Object[] values = new Object[this.criteriaEvaluators.length];
        for (int i = 0; i < this.criteriaEvaluators.length; ++i) {
            values[i] = this.criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(values);
    }

    protected static Object addUpgradeToDequeIfPopulated(Object holder, EventBean theEvent) {
        if (holder == null) {
            return theEvent;
        }
        if (holder instanceof Deque) {
            ArrayDeque deque = (ArrayDeque)holder;
            deque.add(theEvent);
            return deque;
        }
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(4);
        deque.add((EventBean)holder);
        deque.add(theEvent);
        return deque;
    }

    protected static EventBean[] convertToArray(Object eventOrDeque) {
        if (eventOrDeque == null) {
            return null;
        }
        if (eventOrDeque instanceof EventBean) {
            return new EventBean[]{(EventBean)eventOrDeque};
        }
        return EventBeanUtility.toArray((ArrayDeque)eventOrDeque);
    }
}

