/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewFactoryUniqueCandidate;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.std.UniqueByPropertyView;
import java.util.List;
import java.util.Set;

public class UniqueByPropertyViewFactory
implements DataWindowViewFactoryUniqueCandidate,
DataWindowViewFactory {
    protected List<ExprNode> viewParameters;
    protected ExprNode[] criteriaExpressions;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.criteriaExpressions = ViewFactorySupport.validate("Unique-by view", parentEventType, statementContext, this.viewParameters, false);
        if (this.criteriaExpressions.length == 0) {
            String errorMessage = "Unique-by view requires a one or more expressions provinding unique values as parameters";
            throw new ViewParameterException(errorMessage);
        }
        this.eventType = parentEventType;
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new UniqueByPropertyView(this.criteriaExpressions, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof UniqueByPropertyView)) {
            return false;
        }
        UniqueByPropertyView myView = (UniqueByPropertyView)view;
        if (!ExprNodeUtility.deepEquals(this.criteriaExpressions, myView.getCriteriaExpressions())) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public Set<String> getUniquenessCandidatePropertyNames() {
        return ExprNodeUtility.getPropertyNamesIfAllProps(this.criteriaExpressions);
    }
}

