/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stream;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.RefCountedMap;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.ZeroDepthStream;
import com.espertech.esper.view.stream.EventStreamProxy;
import com.espertech.esper.view.stream.StreamFactoryService;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.IdentityHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamFactorySvcImpl
implements StreamFactoryService {
    private static Log log = LogFactory.getLog(StreamFactorySvcImpl.class);
    private final IdentityHashMap<Object, Pair<EventStream, EPStatementHandleCallback>> eventStreamsIdentity;
    private final RefCountedMap<FilterSpecCompiled, Pair<EventStream, EPStatementHandleCallback>> eventStreamsRefCounted;
    private final String engineURI;
    private final boolean isReuseViews;

    public StreamFactorySvcImpl(String engineURI, boolean isReuseViews) {
        this.engineURI = engineURI;
        this.eventStreamsRefCounted = new RefCountedMap();
        this.eventStreamsIdentity = new IdentityHashMap();
        this.isReuseViews = isReuseViews;
    }

    @Override
    public void destroy() {
        this.eventStreamsRefCounted.clear();
        this.eventStreamsIdentity.clear();
    }

    @Override
    public Pair<EventStream, StatementAgentInstanceLock> createStream(final String statementId, final FilterSpecCompiled filterSpec, FilterService filterService, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, boolean isJoin, final boolean isSubSelect, final ExprEvaluatorContext exprEvaluatorContext, boolean isNamedWindowTrigger, boolean filterWithSameTypeSubselect, Annotation[] annotations, boolean stateless) {
        EventStream inputStream;
        boolean forceNewStream;
        Pair<EventStream, EPStatementHandleCallback> pair;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".createStream hashCode=" + filterSpec.hashCode() + " filter=" + filterSpec));
        }
        if ((pair = (forceNewStream = isJoin || !this.isReuseViews || isSubSelect || isNamedWindowTrigger || filterWithSameTypeSubselect || stateless) ? this.eventStreamsIdentity.get(filterSpec) : this.eventStreamsRefCounted.get(filterSpec)) != null) {
            if (forceNewStream) {
                throw new IllegalStateException("Filter spec object already found in collection");
            }
            log.debug((Object)".createStream filter already found");
            this.eventStreamsRefCounted.reference(filterSpec);
            EventStream eventStream = EventStreamProxy.getAuditProxy(this.engineURI, epStatementAgentInstanceHandle.getStatementHandle().getStatementName(), annotations, filterSpec, pair.getFirst());
            return new Pair<EventStream, StatementAgentInstanceLock>(eventStream, pair.getSecond().getAgentInstanceHandle().getStatementAgentInstanceLock());
        }
        EventType resultEventType = filterSpec.getResultEventType();
        ZeroDepthStream zeroDepthStream = new ZeroDepthStream(resultEventType);
        final EventStream eventStream = inputStream = EventStreamProxy.getAuditProxy(this.engineURI, epStatementAgentInstanceHandle.getStatementHandle().getStatementName(), annotations, filterSpec, zeroDepthStream);
        FilterHandleCallback filterCallback = filterSpec.getOptionalPropertyEvaluator() != null ? new FilterHandleCallback(){

            @Override
            public String getStatementId() {
                return statementId;
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                EventBean[] result = filterSpec.getOptionalPropertyEvaluator().getProperty(theEvent, exprEvaluatorContext);
                if (result == null) {
                    return;
                }
                eventStream.insert(result);
            }

            @Override
            public boolean isSubSelect() {
                return isSubSelect;
            }
        } : new FilterHandleCallback(){

            @Override
            public String getStatementId() {
                return statementId;
            }

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                eventStream.insert(theEvent);
            }

            @Override
            public boolean isSubSelect() {
                return isSubSelect;
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(epStatementAgentInstanceHandle, filterCallback);
        pair = new Pair<EventStream, EPStatementHandleCallback>(eventStream, handle);
        if (forceNewStream) {
            this.eventStreamsIdentity.put(filterSpec, pair);
        } else {
            this.eventStreamsRefCounted.put(filterSpec, pair);
        }
        FilterValueSet filterValues = filterSpec.getValueSet(null, exprEvaluatorContext, null);
        filterService.add(filterValues, handle);
        return new Pair<EventStream, Object>(inputStream, null);
    }

    @Override
    public void dropStream(FilterSpecCompiled filterSpec, FilterService filterService, boolean isJoin, boolean isSubSelect, boolean isNamedWindowTrigger, boolean filterWithSameTypeSubselect, boolean stateless) {
        boolean forceNewStream;
        boolean bl = forceNewStream = isJoin || !this.isReuseViews || isSubSelect || isNamedWindowTrigger || filterWithSameTypeSubselect || stateless;
        if (forceNewStream) {
            Pair<EventStream, EPStatementHandleCallback> pair = this.eventStreamsIdentity.get(filterSpec);
            if (pair == null) {
                throw new IllegalStateException("Filter spec object not in collection");
            }
            this.eventStreamsIdentity.remove(filterSpec);
            filterService.remove(pair.getSecond());
        } else {
            Pair<EventStream, EPStatementHandleCallback> pair = this.eventStreamsRefCounted.get(filterSpec);
            boolean isLast = this.eventStreamsRefCounted.dereference(filterSpec);
            if (isLast) {
                filterService.remove(pair.getSecond());
            }
        }
    }
}

