/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.ExpressionBatchView;
import com.espertech.esper.view.window.ExpressionViewFactoryBase;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import java.util.HashMap;
import java.util.List;

public class ExpressionBatchViewFactory
extends ExpressionViewFactoryBase
implements DataWindowBatchingViewFactory {
    private boolean includeTriggeringEvent = true;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        if (expressionParameters.size() != 1 && expressionParameters.size() != 2) {
            String errorMessage = "Expression window view requires a single expression as a parameter, or an expression and boolean flag";
            throw new ViewParameterException(errorMessage);
        }
        this.expiryExpression = expressionParameters.get(0);
        if (expressionParameters.size() > 1) {
            Object result = ViewFactorySupport.evaluateAssertNoProperties("expression batch window", expressionParameters.get(1), 1, new ExprEvaluatorContextStatement(viewFactoryContext.getStatementContext()));
            this.includeTriggeringEvent = (Boolean)result;
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        MapEventBean builtinMapBean = new MapEventBean(new HashMap<String, Object>(), this.builtinMapType);
        IStreamRelativeAccess relativeAccessByEvent = ViewServiceHelper.getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        return new ExpressionBatchView(this, relativeAccessByEvent, this.expiryExpression.getExprEvaluator(), this.aggregationServiceFactoryDesc, builtinMapBean, this.variableNames, agentInstanceViewFactoryContext);
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexMap();
    }

    public boolean isIncludeTriggeringEvent() {
        return this.includeTriggeringEvent;
    }
}

