/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.ViewSupport;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class ExpressionViewBase
extends ViewSupport
implements DataWindowView,
CloneableView,
StoppableView,
VariableChangeCallback,
StopCallback {
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final ExprEvaluator expiryExpression;
    protected final MapEventBean builtinEventProps;
    protected final EventBean[] eventsPerStream;
    protected final Set<String> variableNames;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final ScheduleSlot scheduleSlot;
    protected final EPStatementHandleCallback scheduleHandle;
    protected final AggregationService aggregationService;
    protected final List<AggregationServiceAggExpressionDesc> aggregateNodes;

    public abstract void scheduleCallback();

    public ExpressionViewBase(ViewUpdatedCollection viewUpdatedCollection, ExprEvaluator expiryExpression, AggregationServiceFactoryDesc aggregationServiceFactoryDesc, MapEventBean builtinEventProps, Set<String> variableNames, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.expiryExpression = expiryExpression;
        this.builtinEventProps = builtinEventProps;
        this.eventsPerStream = new EventBean[]{null, builtinEventProps};
        this.variableNames = variableNames;
        this.agentInstanceContext = agentInstanceContext;
        if (variableNames != null && !variableNames.isEmpty()) {
            for (String variable : variableNames) {
                final VariableService variableService = agentInstanceContext.getStatementContext().getVariableService();
                final VariableReader reader = variableService.getReader(variable);
                agentInstanceContext.getStatementContext().getVariableService().registerCallback(reader.getVariableNumber(), this);
                agentInstanceContext.addTerminationCallback(new StopCallback(){

                    @Override
                    public void stop() {
                        variableService.unregisterCallback(reader.getVariableNumber(), ExpressionViewBase.this);
                    }
                });
            }
            ScheduleHandleCallback callback = new ScheduleHandleCallback(){

                @Override
                public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                    ExpressionViewBase.this.scheduleCallback();
                }
            };
            this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            this.scheduleHandle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
            agentInstanceContext.addTerminationCallback(this);
        } else {
            this.scheduleSlot = null;
            this.scheduleHandle = null;
        }
        if (aggregationServiceFactoryDesc != null) {
            this.aggregationService = aggregationServiceFactoryDesc.getAggregationServiceFactory().makeService(agentInstanceContext.getAgentInstanceContext(), agentInstanceContext.getAgentInstanceContext().getStatementContext().getMethodResolutionService());
            this.aggregateNodes = aggregationServiceFactoryDesc.getExpressions();
        } else {
            this.aggregationService = null;
            this.aggregateNodes = Collections.emptyList();
        }
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    @Override
    public void stopView() {
        this.stopScheduleAndVar();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopScheduleAndVar();
    }

    public void stopScheduleAndVar() {
        if (this.variableNames != null && !this.variableNames.isEmpty()) {
            for (String variable : this.variableNames) {
                VariableReader reader = this.agentInstanceContext.getStatementContext().getVariableService().getReader(variable);
                if (reader == null) continue;
                this.agentInstanceContext.getStatementContext().getVariableService().unregisterCallback(reader.getVariableNumber(), this);
            }
            if (this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            }
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    public AggregationService getAggregationService() {
        return this.aggregationService;
    }
}

