/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryFactory;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryServiceImpl;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.expression.ExprNodeVariableVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public abstract class ExpressionViewFactoryBase
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private EventType eventType;
    protected ExprNode expiryExpression;
    protected Set<String> variableNames;
    protected AggregationServiceFactoryDesc aggregationServiceFactoryDesc;
    protected EventType builtinMapType;

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
        LinkedHashMap<String, Object> builtinTypeDef = new LinkedHashMap<String, Object>();
        builtinTypeDef.put("current_count", Integer.class);
        builtinTypeDef.put("oldest_timestamp", Long.class);
        builtinTypeDef.put("newest_timestamp", Long.class);
        builtinTypeDef.put("expired_count", Integer.class);
        builtinTypeDef.put("view_reference", Object.class);
        builtinTypeDef.put("newest_event", this.eventType);
        builtinTypeDef.put("oldest_event", this.eventType);
        this.builtinMapType = statementContext.getEventAdapterService().createAnonymousMapType(statementContext.getStatementId() + "_exprview", builtinTypeDef);
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{this.eventType, this.builtinMapType}, new String[2], new boolean[2], statementContext.getEngineURI(), false);
        this.expiryExpression = ViewFactorySupport.validateExpr(statementContext, this.expiryExpression, streamTypeService, 0);
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        this.expiryExpression.accept(summaryVisitor);
        if (summaryVisitor.isHasSubselect() || summaryVisitor.isHasStreamSelect() || summaryVisitor.isHasPreviousPrior()) {
            throw new ViewParameterException("Invalid expiry expression: Sub-select, previous or prior functions are not supported in this context");
        }
        Class returnType = this.expiryExpression.getExprEvaluator().getType();
        if (JavaClassHelper.getBoxedType(returnType) != Boolean.class) {
            throw new ViewParameterException("Invalid return value for expiry expression, expected a boolean return value but received " + JavaClassHelper.getParameterAsString(returnType));
        }
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor();
        this.expiryExpression.accept(visitor);
        this.variableNames = visitor.getVariableNames();
        ArrayList<ExprAggregateNode> aggregateNodes = new ArrayList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(this.expiryExpression, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            try {
                this.aggregationServiceFactoryDesc = AggregationServiceFactoryFactory.getService(Collections.<ExprAggregateNode>emptyList(), aggregateNodes, Collections.<ExprAggregateNode>emptyList(), false, new ExprEvaluatorContextStatement(statementContext), statementContext.getAnnotations(), statementContext.getVariableService(), false, null, null, AggregationServiceFactoryServiceImpl.DEFAULT_FACTORY, streamTypeService.getEventTypes());
            }
            catch (ExprValidationException ex) {
                throw new ViewParameterException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    public EventType getBuiltinMapType() {
        return this.builtinMapType;
    }
}

