/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.ExternallyTimedBatchViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExternallyTimedBatchView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final ExternallyTimedBatchViewFactory factory;
    private final ExprNode timestampExpression;
    private final ExprEvaluator timestampExpressionEval;
    private final long millisecondsBeforeExpiry;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected EventBean[] lastBatch;
    private Long oldestTimestampRoundedToRef;
    protected final Set<EventBean> window = new LinkedHashSet<EventBean>();
    protected Long referenceTimestamp;
    protected ViewUpdatedCollection viewUpdatedCollection;
    protected AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;

    public ExternallyTimedBatchView(ExternallyTimedBatchViewFactory factory, ExprNode timestampExpression, ExprEvaluator timestampExpressionEval, long msecBeforeExpiry, Long optionalReferencePoint, ViewUpdatedCollection viewUpdatedCollection, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.factory = factory;
        this.timestampExpression = timestampExpression;
        this.timestampExpressionEval = timestampExpressionEval;
        this.millisecondsBeforeExpiry = msecBeforeExpiry;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.referenceTimestamp = optionalReferencePoint;
    }

    @Override
    public View cloneView() {
        return this.factory.makeView(this.agentInstanceViewFactoryContext);
    }

    public final ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null && oldData.length != 0) {
            for (EventBean anOldData : oldData) {
                this.window.remove(anOldData);
                this.handleInternalRemovedEvent(anOldData);
            }
            this.determineOldestTimestamp();
        }
        EventBean[] batchNewData = null;
        if (newData != null) {
            for (EventBean newEvent : newData) {
                long timestamp = this.getLongValue(newEvent);
                if (this.referenceTimestamp == null) {
                    this.referenceTimestamp = timestamp;
                }
                if (this.oldestTimestampRoundedToRef == null) {
                    this.oldestTimestampRoundedToRef = this.roundDownTimestamp(timestamp);
                } else if (timestamp - this.oldestTimestampRoundedToRef >= this.millisecondsBeforeExpiry) {
                    batchNewData = batchNewData == null ? this.window.toArray(new EventBean[this.window.size()]) : EventBeanUtility.addToArray(batchNewData, this.window);
                    this.window.clear();
                    this.oldestTimestampRoundedToRef = null;
                }
                this.window.add(newEvent);
                this.handleInternalAddEvent(newEvent, batchNewData != null);
            }
        }
        if (batchNewData != null) {
            this.handleInternalPostBatch(this.window, batchNewData);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            this.updateChildren(batchNewData, this.lastBatch);
            this.lastBatch = batchNewData;
            this.determineOldestTimestamp();
        }
        if (oldData != null && oldData.length > 0) {
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            this.updateChildren(null, oldData);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.window.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression + " millisecondsBeforeExpiry=" + this.millisecondsBeforeExpiry;
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    public long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    protected void determineOldestTimestamp() {
        if (this.window.isEmpty()) {
            this.oldestTimestampRoundedToRef = null;
        } else {
            long ts = this.getLongValue(this.window.iterator().next());
            this.oldestTimestampRoundedToRef = this.roundDownTimestamp(ts);
        }
    }

    protected void handleInternalPostBatch(Set<EventBean> window, EventBean[] batchNewData) {
    }

    protected void handleInternalRemovedEvent(EventBean anOldData) {
    }

    protected void handleInternalAddEvent(EventBean anNewData, boolean isNextBatch) {
    }

    private long roundDownTimestamp(long timestamp) {
        if (timestamp <= this.referenceTimestamp) {
            return this.referenceTimestamp;
        }
        long delta = Math.abs(timestamp - this.referenceTimestamp);
        long factor = delta / this.millisecondsBeforeExpiry;
        return this.referenceTimestamp + factor * this.millisecondsBeforeExpiry;
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.timestampExpressionEval.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        return num.longValue();
    }
}

