/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.TimeWindow;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.ExternallyTimedWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class ExternallyTimedWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory;
    private final ExprNode timestampExpression;
    private final ExprEvaluator timestampExpressionEval;
    private final long millisecondsBeforeExpiry;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final TimeWindow timeWindow;
    private ViewUpdatedCollection viewUpdatedCollection;
    protected AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;

    public ExternallyTimedWindowView(ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory, ExprNode timestampExpression, ExprEvaluator timestampExpressionEval, long msecBeforeExpiry, ViewUpdatedCollection viewUpdatedCollection, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.externallyTimedWindowViewFactory = externallyTimedWindowViewFactory;
        this.timestampExpression = timestampExpression;
        this.timestampExpressionEval = timestampExpressionEval;
        this.millisecondsBeforeExpiry = msecBeforeExpiry;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.timeWindow = new TimeWindow(agentInstanceViewFactoryContext.isRemoveStream());
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
    }

    @Override
    public View cloneView() {
        return this.externallyTimedWindowViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public final ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    public final long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long timestamp = -1L;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                timestamp = this.getLongValue(newData[i]);
                this.timeWindow.add(timestamp, newData[i]);
            }
        }
        ArrayDeque<EventBean> expired = null;
        if (timestamp != -1L) {
            expired = this.timeWindow.expireEvents(timestamp - this.millisecondsBeforeExpiry + 1L);
        }
        EventBean[] oldDataUpdate = null;
        if (expired != null && !expired.isEmpty()) {
            oldDataUpdate = expired.toArray(new EventBean[expired.size()]);
        }
        if (oldData != null && this.agentInstanceViewFactoryContext.isRemoveStream()) {
            for (EventBean anOldData : oldData) {
                this.timeWindow.remove(anOldData);
            }
            oldDataUpdate = oldDataUpdate == null ? oldData : CollectionUtil.addArrayWithSetSemantics(oldData, oldDataUpdate);
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldDataUpdate);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldDataUpdate);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression + " millisecondsBeforeExpiry=" + this.millisecondsBeforeExpiry;
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.timestampExpressionEval.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        return num.longValue();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }
}

