/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.ExternallyTimedWindowView;
import com.espertech.esper.view.window.IStreamRandomAccess;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class ExternallyTimedWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private List<ExprNode> viewParameters;
    private EventType eventType;
    protected ExprNode timestampExpression;
    protected ExprEvaluator timestampExpressionEval;
    protected long millisecondsBeforeExpiry;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Externally-timed window", parentEventType, statementContext, this.viewParameters, true);
        String errorMessage = "Externally-timed window view requires a timestamp expression and a numeric or time period parameter for window size";
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getExprEvaluator().getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.timestampExpression = validated[0];
        this.timestampExpressionEval = this.timestampExpression.getExprEvaluator();
        ViewFactorySupport.assertReturnsNonConstant("Externally-timed window", validated[0], 0);
        Object parameter = ViewFactorySupport.evaluateAssertNoProperties("Externally-timed window", validated[1], 1, new ExprEvaluatorContextStatement(statementContext));
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number param = (Number)parameter;
        this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRandomAccess randomAccess = ViewServiceHelper.getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        return new ExternallyTimedWindowView(this, this.timestampExpression, this.timestampExpressionEval, this.millisecondsBeforeExpiry, randomAccess, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof ExternallyTimedWindowView)) {
            return false;
        }
        ExternallyTimedWindowView myView = (ExternallyTimedWindowView)view;
        if (myView.getMillisecondsBeforeExpiry() != this.millisecondsBeforeExpiry || !ExprNodeUtility.deepEquals(myView.getTimestampExpression(), this.timestampExpression)) {
            return false;
        }
        return myView.isEmpty();
    }
}

