/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.KeepAllViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class KeepAllView
extends ViewSupport
implements DataWindowView,
CloneableView {
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final KeepAllViewFactory keepAllViewFactory;
    protected LinkedHashSet<EventBean> indexedEvents;
    protected ViewUpdatedCollection viewUpdatedCollection;

    public KeepAllView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, KeepAllViewFactory keepAllViewFactory, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.keepAllViewFactory = keepAllViewFactory;
        this.indexedEvents = new LinkedHashSet();
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    @Override
    public View cloneView() {
        return this.keepAllViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean newEvent : newData) {
                this.indexedEvents.add(newEvent);
                this.internalHandleAdded(newEvent);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
                this.internalHandleRemoved(anOldData);
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldData);
        }
        this.updateChildren(newData, oldData);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public void internalHandleAdded(EventBean newEvent) {
    }

    public void internalHandleRemoved(EventBean oldEvent) {
    }
}

