/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.LengthBatchViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LengthBatchView
extends ViewSupport
implements CloneableView {
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final LengthBatchViewFactory lengthBatchViewFactory;
    private final int size;
    private final ViewUpdatedCollection viewUpdatedCollection;
    protected ArrayDeque<EventBean> lastBatch = null;
    protected ArrayDeque<EventBean> currentBatch = new ArrayDeque();
    private static final Log log = LogFactory.getLog(LengthBatchView.class);

    public LengthBatchView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, LengthBatchViewFactory lengthBatchViewFactory, int size, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.lengthBatchViewFactory = lengthBatchViewFactory;
        this.size = size;
        this.viewUpdatedCollection = viewUpdatedCollection;
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size parameter, size=" + size);
        }
    }

    @Override
    public View cloneView() {
        return this.lengthBatchViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null || newData.length == 0) {
            return;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
        }
        if (this.currentBatch.size() < this.size) {
            return;
        }
        this.sendBatch();
    }

    protected void sendBatch() {
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null) {
                this.updateChildren(newData, oldData);
            }
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayDeque();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

