/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeAccumViewFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeAccumViewRStream
extends ViewSupport
implements CloneableView,
DataWindowView,
StoppableView,
StopCallback {
    private final TimeAccumViewFactory factory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final long msecIntervalSize;
    protected final ScheduleSlot scheduleSlot;
    protected LinkedHashMap<EventBean, Long> currentBatch = new LinkedHashMap();
    protected EventBean lastEvent;
    protected long callbackScheduledTime;
    protected EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(TimeAccumViewRStream.class);

    public TimeAccumViewRStream(TimeAccumViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, long msecIntervalSize) {
        this.agentInstanceContext = agentInstanceContext;
        this.factory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeAccumViewRStream.this.sendRemoveStream();
            }
        };
        this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        agentInstanceContext.addTerminationCallback(this);
    }

    @Override
    public View cloneView() {
        return this.factory.makeView(this.agentInstanceContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && newData.length > 0) {
            boolean removeSchedule = false;
            boolean addSchedule = false;
            long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            if (!this.currentBatch.isEmpty()) {
                long callbackTime = timestamp + this.msecIntervalSize;
                if (callbackTime != this.callbackScheduledTime) {
                    removeSchedule = true;
                    addSchedule = true;
                }
            } else {
                addSchedule = true;
            }
            if (removeSchedule) {
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.callbackScheduledTime = -1L;
            }
            if (addSchedule) {
                this.agentInstanceContext.getStatementContext().getSchedulingService().add(this.msecIntervalSize, this.handle, this.scheduleSlot);
                this.callbackScheduledTime = this.msecIntervalSize + timestamp;
            }
            for (int i = 0; i < newData.length; ++i) {
                this.currentBatch.put(newData[i], timestamp);
                this.internalHandleAdded(newData[i], timestamp);
                this.lastEvent = newData[i];
            }
        }
        if (oldData != null && oldData.length > 0) {
            boolean removedLastEvent = false;
            for (EventBean anOldData : oldData) {
                this.currentBatch.remove(anOldData);
                this.internalHandleRemoved(anOldData);
                if (anOldData != this.lastEvent) continue;
                removedLastEvent = true;
            }
            if (this.currentBatch.size() == 0) {
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.callbackScheduledTime = -1L;
                this.lastEvent = null;
            } else if (removedLastEvent) {
                Set<EventBean> keyset = this.currentBatch.keySet();
                EventBean[] events = keyset.toArray(new EventBean[keyset.size()]);
                this.lastEvent = events[events.length - 1];
                long lastTimestamp = this.currentBatch.get(this.lastEvent);
                long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                long callbackTime = lastTimestamp + this.msecIntervalSize;
                long deltaFromNow = callbackTime - timestamp;
                if (callbackTime != this.callbackScheduledTime) {
                    this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(deltaFromNow, this.handle, this.scheduleSlot);
                    this.callbackScheduledTime = callbackTime;
                }
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldData);
        }
    }

    protected void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (this.hasViews()) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.keySet().toArray(new EventBean[this.currentBatch.size()]);
            }
            if (oldData != null) {
                this.updateChildren(null, oldData);
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.keySet().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    public void internalHandleRemoved(EventBean anOldData) {
    }

    public void internalHandleAdded(EventBean eventBean, long timestamp) {
    }
}

