/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import com.espertech.esper.view.window.TimeBatchView;
import com.espertech.esper.view.window.TimeBatchViewFactoryParams;
import com.espertech.esper.view.window.TimeBatchViewRStream;
import java.util.List;

public class TimeBatchViewFactory
extends TimeBatchViewFactoryParams
implements DataWindowViewFactory,
DataWindowViewWithPrevious,
DataWindowBatchingViewFactory {
    protected Long optionalReferencePoint;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Time batch view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Time batch view requires a single numeric or time period parameter, and an optional long-typed reference point in msec, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (viewParameters.size() < 1 || viewParameters.size() > 3) {
            throw new ViewParameterException(errorMessage);
        }
        this.processExpiry(viewParameters.get(0), errorMessage, "Time batch view requires a size of at least 1 msec");
        if (viewParameters.size() == 2 && viewParameters.get(1) instanceof String) {
            this.processKeywords(viewParameters.get(1), errorMessage);
        } else {
            if (viewParameters.size() >= 2) {
                Object paramRef = viewParameters.get(1);
                if (!(paramRef instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)paramRef)) {
                    throw new ViewParameterException("Time batch view requires a Long-typed reference point in msec as a second parameter");
                }
                this.optionalReferencePoint = ((Number)paramRef).longValue();
            }
            if (viewParameters.size() == 3) {
                this.processKeywords(viewParameters.get(2), errorMessage);
            }
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexMap();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRelativeAccess relativeAccessByEvent = ViewServiceHelper.getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        if (agentInstanceViewFactoryContext.isRemoveStream()) {
            return new TimeBatchViewRStream(this, agentInstanceViewFactoryContext, this.millisecondsBeforeExpiry, this.optionalReferencePoint, this.isForceUpdate, this.isStartEager);
        }
        return new TimeBatchView(this, agentInstanceViewFactoryContext, this.millisecondsBeforeExpiry, this.optionalReferencePoint, this.isForceUpdate, this.isStartEager, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof TimeBatchView)) {
            return false;
        }
        TimeBatchView myView = (TimeBatchView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsBeforeExpiry) {
            return false;
        }
        if (myView.getInitialReferencePoint() != null && this.optionalReferencePoint != null && !myView.getInitialReferencePoint().equals((long)this.optionalReferencePoint)) {
            return false;
        }
        if (myView.getInitialReferencePoint() == null && this.optionalReferencePoint != null || myView.getInitialReferencePoint() != null && this.optionalReferencePoint == null) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }
}

