/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeLengthBatchViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeLengthBatchView
extends ViewSupport
implements CloneableView,
StoppableView,
StopCallback,
DataWindowView {
    private static final Log log = LogFactory.getLog(TimeLengthBatchView.class);
    private final TimeLengthBatchViewFactory timeLengthBatchViewFactory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final long msecIntervalSize;
    protected final long numberOfEvents;
    protected final boolean isForceOutput;
    protected final boolean isStartEager;
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final ScheduleSlot scheduleSlot;
    protected ArrayList<EventBean> lastBatch = null;
    protected ArrayList<EventBean> currentBatch = new ArrayList();
    protected Long callbackScheduledTime;
    protected EPStatementHandleCallback handle;

    public TimeLengthBatchView(TimeLengthBatchViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, long msecIntervalSize, long numberOfEvents, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeLengthBatchViewFactory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.numberOfEvents = numberOfEvents;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartEager) {
            this.scheduleCallback(0L);
        }
        agentInstanceContext.addTerminationCallback(this);
    }

    @Override
    public View cloneView() {
        return this.timeLengthBatchViewFactory.makeView(this.agentInstanceContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                if (!this.currentBatch.remove(oldData[i])) continue;
                this.internalHandleRemoved(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
            this.internalHandleAdded(newEvent);
        }
        if ((long)this.currentBatch.size() < this.numberOfEvents) {
            if (this.callbackScheduledTime == null) {
                this.scheduleCallback(0L);
            }
            return;
        }
        this.sendBatch(false);
    }

    public void internalHandleAdded(EventBean newEvent) {
    }

    public void internalHandleRemoved(EventBean eventBean) {
    }

    protected void sendBatch(boolean isFromSchedule) {
        if (isFromSchedule) {
            this.callbackScheduledTime = null;
        } else if (this.callbackScheduledTime != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.callbackScheduledTime = null;
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback(0L);
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize + " numberOfEvents=" + this.numberOfEvents;
    }

    protected void scheduleCallback(long delta) {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeLengthBatchView.this.sendBatch(true);
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(this.msecIntervalSize - delta, this.handle, this.scheduleSlot);
        this.callbackScheduledTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime() - delta;
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

