/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.TimeWindow;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleAdjustmentCallback;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeWindowView
extends ViewSupport
implements CloneableView,
DataWindowView,
ScheduleAdjustmentCallback,
StoppableView,
StopCallback {
    private final TimeWindowViewFactory timeWindowViewFactory;
    private final long millisecondsBeforeExpiry;
    protected final TimeWindow timeWindow;
    private final ViewUpdatedCollection viewUpdatedCollection;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final ScheduleSlot scheduleSlot;
    private final EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(TimeWindowView.class);

    public TimeWindowView(AgentInstanceViewFactoryChainContext agentInstanceContext, TimeWindowViewFactory timeWindowViewFactory, long millisecondsBeforeExpiry, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeWindowViewFactory = timeWindowViewFactory;
        this.millisecondsBeforeExpiry = millisecondsBeforeExpiry;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timeWindow = new TimeWindow(agentInstanceContext.isRemoveStream());
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeWindowView.this.expire();
            }
        };
        this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        agentInstanceContext.getStatementContext().getScheduleAdjustmentService().addCallback(this);
        agentInstanceContext.addTerminationCallback(this);
    }

    @Override
    public void adjust(long delta) {
        this.timeWindow.adjust(delta);
    }

    @Override
    public View cloneView() {
        return this.timeWindowViewFactory.makeView(this.agentInstanceContext);
    }

    public final long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.timeWindow.remove(oldData[i]);
            }
        }
        if (newData != null && newData.length > 0) {
            if (this.timeWindow.isEmpty()) {
                this.scheduleCallback(this.millisecondsBeforeExpiry);
            }
            for (i = 0; i < newData.length; ++i) {
                this.timeWindow.add(timestamp, newData[i]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, null);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldData);
        }
    }

    protected final void expire() {
        long expireBeforeTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime() - this.millisecondsBeforeExpiry + 1L;
        ArrayDeque<EventBean> expired = this.timeWindow.expireEvents(expireBeforeTimestamp);
        if (this.hasViews() && expired != null && !expired.isEmpty()) {
            EventBean[] oldEvents = expired.toArray(new EventBean[expired.size()]);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldEvents);
            }
            this.updateChildren(null, oldEvents);
        }
        this.scheduleExpiryCallback();
    }

    protected void scheduleExpiryCallback() {
        if (this.timeWindow.isEmpty()) {
            return;
        }
        Long oldestTimestamp = this.timeWindow.getOldestTimestamp();
        long currentTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long scheduleMillisec = this.millisecondsBeforeExpiry - (currentTimestamp - oldestTimestamp);
        this.scheduleCallback(scheduleMillisec);
    }

    private void scheduleCallback(long msecAfterCurrentTime) {
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(msecAfterCurrentTime, this.handle, this.scheduleSlot);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " millisecondsBeforeExpiry=" + this.millisecondsBeforeExpiry;
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
        this.agentInstanceContext.getStatementContext().getScheduleAdjustmentService().removeCallback(this);
    }
}

