/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.federation.validation;

import com.expediagroup.graphql.federation.exception.InvalidFederatedSchema;
import com.expediagroup.graphql.federation.extensions.GraphQLDirectiveContainerExtensionsKt;
import com.expediagroup.graphql.federation.validation.ValidateDirectiveKt;
import com.expediagroup.graphql.federation.validation.ValidateProvidesDirectiveKt;
import com.expediagroup.graphql.federation.validation.ValidateRequiresDirectiveKt;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/expediagroup/graphql/federation/validation/FederatedSchemaValidator;", "", "()V", "validate", "", "federatedType", "", "fields", "", "Lgraphql/schema/GraphQLFieldDefinition;", "directives", "", "Lgraphql/schema/GraphQLDirective;", "validateGraphQLType", "type", "Lgraphql/schema/GraphQLType;", "validateGraphQLType$graphql_kotlin_federation", "graphql-kotlin-federation"})
public final class FederatedSchemaValidator {
    public final void validateGraphQLType$graphql_kotlin_federation(@NotNull GraphQLType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll((GraphQLType)type);
        if (unwrappedType instanceof GraphQLObjectType && GraphQLDirectiveContainerExtensionsKt.isFederatedType((GraphQLDirectiveContainer)unwrappedType)) {
            String string = ((GraphQLObjectType)unwrappedType).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unwrappedType.name");
            List list = ((GraphQLObjectType)unwrappedType).getFieldDefinitions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"unwrappedType.fieldDefinitions");
            Map map2 = ((GraphQLObjectType)unwrappedType).getDirectivesByName();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"unwrappedType.directivesByName");
            this.validate(string, list, map2);
        } else if (unwrappedType instanceof GraphQLInterfaceType && GraphQLDirectiveContainerExtensionsKt.isFederatedType((GraphQLDirectiveContainer)unwrappedType)) {
            String string = ((GraphQLInterfaceType)unwrappedType).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unwrappedType.name");
            List list = ((GraphQLInterfaceType)unwrappedType).getFieldDefinitions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"unwrappedType.fieldDefinitions");
            Map map3 = ((GraphQLInterfaceType)unwrappedType).getDirectivesByName();
            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"unwrappedType.directivesByName");
            this.validate(string, list, map3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validate(String federatedType, List<? extends GraphQLFieldDefinition> fields, Map<String, ? extends GraphQLDirective> directives) {
        String string;
        Object object;
        void $this$associateByTo$iv$iv;
        boolean bl = false;
        List errors = new ArrayList();
        Iterable $this$associateBy$iv = fields;
        boolean bl2 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GraphQLFieldDefinition graphQLFieldDefinition = (GraphQLFieldDefinition)element$iv$iv;
            object = destination$iv$iv;
            boolean bl22 = false;
            string = it.getName();
            object.put(string, element$iv$iv);
        }
        Map fieldMap = destination$iv$iv;
        boolean extendedType = directives.containsKey("extends");
        errors.addAll((Collection)ValidateDirectiveKt.validateDirective(federatedType, "key", directives, fieldMap, extendedType));
        for (GraphQLFieldDefinition graphQLFieldDefinition : fields) {
            if (graphQLFieldDefinition.getDirective("requires") != null) {
                errors.addAll((Collection)ValidateRequiresDirectiveKt.validateRequiresDirective(federatedType, graphQLFieldDefinition, fieldMap, extendedType));
            }
            if (graphQLFieldDefinition.getDirective("provides") == null) continue;
            errors.addAll((Collection)ValidateProvidesDirectiveKt.validateProvidesDirective(federatedType, graphQLFieldDefinition));
        }
        if (!extendedType) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = fields;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GraphQLFieldDefinition it = (GraphQLFieldDefinition)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getDirective("external") != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GraphQLFieldDefinition it = (GraphQLFieldDefinition)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl4 = false;
                string = it.getName();
                object.add(string);
            }
            List list = (List)destination$iv$iv3;
            Collection collection = list;
            boolean bl5 = false;
            if (!collection.isEmpty()) {
                errors.add("base " + federatedType + " type has fields marked with @external directive, fields=" + list);
            }
        }
        Collection collection = errors;
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)((Object)new InvalidFederatedSchema(errors));
        }
    }
}

