/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.federation.validation;

import com.expediagroup.graphql.generator.federation.validation.DirectiveInfo;
import com.expediagroup.graphql.generator.federation.validation.DirectiveInfoKt;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"validateFieldSet", "", "fieldName", "", "targetField", "Lgraphql/schema/GraphQLFieldDefinition;", "extendedType", "", "errors", "", "validatedDirective", "Lcom/expediagroup/graphql/generator/federation/validation/DirectiveInfo;", "graphql-kotlin-federation"})
public final class ValidateFieldSetKt {
    public static final void validateFieldSet(@NotNull String fieldName, @Nullable GraphQLFieldDefinition targetField, boolean extendedType, @NotNull List<String> errors, @NotNull DirectiveInfo validatedDirective) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Intrinsics.checkNotNullParameter((Object)validatedDirective, (String)"validatedDirective");
        String errorMessage = DirectiveInfoKt.getErrorString(validatedDirective);
        if (targetField != null) {
            boolean externalField;
            boolean bl = externalField = targetField.getDirective("external") != null;
            if (extendedType && !externalField) {
                errors.add(errorMessage + " specifies invalid field set - extended type incorrectly references local field=" + targetField.getName());
            } else if (!extendedType && externalField) {
                errors.add(errorMessage + " specifies invalid field set - type incorrectly references external field=" + targetField.getName());
            }
            if (!Intrinsics.areEqual((Object)validatedDirective.getDirectiveName(), (Object)"requires")) {
                GraphQLType graphQLType = GraphQLTypeUtil.unwrapNonNull((GraphQLType)((GraphQLType)targetField.getType()));
                if (graphQLType instanceof GraphQLList) {
                    errors.add(errorMessage + " specifies invalid field set - field set references GraphQLList, field=" + targetField.getName());
                } else if (graphQLType instanceof GraphQLInterfaceType) {
                    errors.add(errorMessage + " specifies invalid field set - field set references GraphQLInterfaceType, field=" + targetField.getName());
                } else if (graphQLType instanceof GraphQLUnionType) {
                    errors.add(errorMessage + " specifies invalid field set - field set references GraphQLUnionType, field=" + targetField.getName());
                }
            }
        } else {
            errors.add(errorMessage + " specifies invalid field set - field set specifies field that does not exist, field=" + fieldName);
        }
    }
}

