/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.references;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.ResourceReleaser;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

@VisibleForTesting
public class SharedReference<T> {
    @GuardedBy(value="itself")
    private static final Map<Object, Integer> sLiveObjects = new IdentityHashMap<Object, Integer>();
    @GuardedBy(value="this")
    private T mValue;
    @GuardedBy(value="this")
    private int mRefCount;
    private final ResourceReleaser<T> mResourceReleaser;

    public SharedReference(T value, ResourceReleaser<T> resourceReleaser) {
        this.mValue = Preconditions.checkNotNull(value);
        this.mResourceReleaser = Preconditions.checkNotNull(resourceReleaser);
        this.mRefCount = 1;
        SharedReference.addLiveReference(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLiveReference(Object value) {
        Map<Object, Integer> map = sLiveObjects;
        synchronized (map) {
            Integer count = sLiveObjects.get(value);
            if (count == null) {
                sLiveObjects.put(value, 1);
            } else {
                sLiveObjects.put(value, count + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLiveReference(Object value) {
        Map<Object, Integer> map = sLiveObjects;
        synchronized (map) {
            Integer count = sLiveObjects.get(value);
            if (count == null) {
                FLog.wtf("SharedReference", "No entry in sLiveObjects for value of type %s", value.getClass());
            } else if (count == 1) {
                sLiveObjects.remove(value);
            } else {
                sLiveObjects.put(value, count - 1);
            }
        }
    }

    public synchronized T get() {
        return this.mValue;
    }

    public synchronized boolean isValid() {
        return this.mRefCount > 0;
    }

    public static boolean isValid(SharedReference<?> ref) {
        return ref != null && ref.isValid();
    }

    public synchronized void addReference() {
        this.ensureValid();
        ++this.mRefCount;
    }

    public synchronized boolean addReferenceIfValid() {
        if (this.isValid()) {
            this.addReference();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReference() {
        if (this.decreaseRefCount() == 0) {
            T deleted;
            SharedReference sharedReference = this;
            synchronized (sharedReference) {
                deleted = this.mValue;
                this.mValue = null;
            }
            this.mResourceReleaser.release(deleted);
            SharedReference.removeLiveReference(deleted);
        }
    }

    private synchronized int decreaseRefCount() {
        this.ensureValid();
        Preconditions.checkArgument(this.mRefCount > 0);
        --this.mRefCount;
        return this.mRefCount;
    }

    private void ensureValid() {
        if (!SharedReference.isValid(this)) {
            throw new NullReferenceException();
        }
    }

    public synchronized int getRefCountTestOnly() {
        return this.mRefCount;
    }

    public static class NullReferenceException
    extends RuntimeException {
        public NullReferenceException() {
            super("Null shared reference");
        }
    }
}

