/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.BitmapPoolBackend;
import com.facebook.imagepipeline.memory.PoolBackend;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import javax.annotation.Nullable;

public class LruBitmapPool
implements BitmapPool {
    protected final PoolBackend<Bitmap> mStrategy = new BitmapPoolBackend();
    private final int mMaxPoolSize;
    private int mMaxBitmapSize;
    private final PoolStatsTracker mPoolStatsTracker;
    private int mCurrentSize;

    public LruBitmapPool(int maxPoolSize, int maxBitmapSize, PoolStatsTracker poolStatsTracker, @Nullable MemoryTrimmableRegistry memoryTrimmableRegistry) {
        this.mMaxPoolSize = maxPoolSize;
        this.mMaxBitmapSize = maxBitmapSize;
        this.mPoolStatsTracker = poolStatsTracker;
        if (memoryTrimmableRegistry != null) {
            memoryTrimmableRegistry.registerMemoryTrimmable((MemoryTrimmable)this);
        }
    }

    public void trim(MemoryTrimType trimType) {
        this.trimTo((int)((double)this.mMaxPoolSize * (1.0 - trimType.getSuggestedTrimRatio())));
    }

    private synchronized void trimTo(int maxSize) {
        Bitmap removed;
        while (this.mCurrentSize > maxSize && (removed = this.mStrategy.pop()) != null) {
            int size = this.mStrategy.getSize(removed);
            this.mCurrentSize -= size;
            this.mPoolStatsTracker.onFree(size);
        }
    }

    public synchronized Bitmap get(int size) {
        Bitmap cached;
        if (this.mCurrentSize > this.mMaxPoolSize) {
            this.trimTo(this.mMaxPoolSize);
        }
        if ((cached = this.mStrategy.get(size)) != null) {
            int reusedSize = this.mStrategy.getSize(cached);
            this.mCurrentSize -= reusedSize;
            this.mPoolStatsTracker.onValueReuse(reusedSize);
            return cached;
        }
        return this.alloc(size);
    }

    @VisibleForTesting
    private Bitmap alloc(int size) {
        this.mPoolStatsTracker.onAlloc(size);
        return Bitmap.createBitmap((int)1, (int)size, (Bitmap.Config)Bitmap.Config.ALPHA_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Bitmap value) {
        int size = this.mStrategy.getSize(value);
        if (size <= this.mMaxBitmapSize) {
            this.mPoolStatsTracker.onValueRelease(size);
            this.mStrategy.put(value);
            LruBitmapPool lruBitmapPool = this;
            synchronized (lruBitmapPool) {
                this.mCurrentSize += size;
            }
        }
    }
}

