/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.graphics.Rect;
import android.os.Build;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.common.TooManyBitmapsException;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.imagepipeline.memory.BitmapCounterProvider;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.soloader.DoNotOptimize;
import java.util.Locale;
import javax.annotation.Nullable;

@DoNotStrip
public abstract class DalvikPurgeableDecoder
implements PlatformDecoder {
    protected static final byte[] EOI;
    private final BitmapCounter mUnpooledBitmapsCounter = BitmapCounterProvider.get();

    protected DalvikPurgeableDecoder() {
    }

    @Override
    public CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode) {
        return this.decodeFromEncodedImageWithColorSpace(encodedImage, bitmapConfig, regionToDecode, null);
    }

    @Override
    public CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode, int length) {
        return this.decodeJPEGFromEncodedImageWithColorSpace(encodedImage, bitmapConfig, regionToDecode, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> decodeFromEncodedImageWithColorSpace(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode, @Nullable ColorSpace colorSpace) {
        BitmapFactory.Options options = DalvikPurgeableDecoder.getBitmapFactoryOptions(encodedImage.getSampleSize(), bitmapConfig);
        if (Build.VERSION.SDK_INT >= 26) {
            OreoUtils.setColorSpace(options, colorSpace);
        }
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            Bitmap bitmap = this.decodeByteArrayAsPurgeable((CloseableReference<PooledByteBuffer>)bytesRef, options);
            CloseableReference<Bitmap> closeableReference = this.pinBitmap(bitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> decodeJPEGFromEncodedImageWithColorSpace(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode, int length, @Nullable ColorSpace colorSpace) {
        BitmapFactory.Options options = DalvikPurgeableDecoder.getBitmapFactoryOptions(encodedImage.getSampleSize(), bitmapConfig);
        if (Build.VERSION.SDK_INT >= 26) {
            OreoUtils.setColorSpace(options, colorSpace);
        }
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            Bitmap bitmap = this.decodeJPEGByteArrayAsPurgeable((CloseableReference<PooledByteBuffer>)bytesRef, length, options);
            CloseableReference<Bitmap> closeableReference = this.pinBitmap(bitmap);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
    }

    protected abstract Bitmap decodeByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> var1, BitmapFactory.Options var2);

    protected abstract Bitmap decodeJPEGByteArrayAsPurgeable(CloseableReference<PooledByteBuffer> var1, int var2, BitmapFactory.Options var3);

    @VisibleForTesting
    public static BitmapFactory.Options getBitmapFactoryOptions(int sampleSize, Bitmap.Config bitmapConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = true;
        options.inPreferredConfig = bitmapConfig;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = sampleSize;
        if (Build.VERSION.SDK_INT >= 11) {
            options.inMutable = true;
        }
        return options;
    }

    @VisibleForTesting
    public static boolean endsWithEOI(CloseableReference<PooledByteBuffer> bytesRef, int length) {
        PooledByteBuffer buffer = (PooledByteBuffer)bytesRef.get();
        return length >= 2 && buffer.read(length - 2) == -1 && buffer.read(length - 1) == -39;
    }

    public CloseableReference<Bitmap> pinBitmap(Bitmap bitmap) {
        Preconditions.checkNotNull((Object)bitmap);
        try {
            DalvikPurgeableDecoder.nativePinBitmap(bitmap);
        }
        catch (Exception e) {
            bitmap.recycle();
            throw Throwables.propagate((Throwable)e);
        }
        if (!this.mUnpooledBitmapsCounter.increase(bitmap)) {
            int bitmapSize = BitmapUtil.getSizeInBytes((Bitmap)bitmap);
            bitmap.recycle();
            String detailMessage = String.format(Locale.US, "Attempted to pin a bitmap of size %d bytes. The current pool count is %d, the current pool size is %d bytes. The current pool max count is %d, the current pool max size is %d bytes.", bitmapSize, this.mUnpooledBitmapsCounter.getCount(), this.mUnpooledBitmapsCounter.getSize(), this.mUnpooledBitmapsCounter.getMaxCount(), this.mUnpooledBitmapsCounter.getMaxSize());
            throw new TooManyBitmapsException(detailMessage);
        }
        return CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsCounter.getReleaser());
    }

    @DoNotStrip
    private static native void nativePinBitmap(Bitmap var0);

    static {
        ImagePipelineNativeLoader.load();
        EOI = new byte[]{-1, -39};
    }

    @DoNotOptimize
    private static class OreoUtils {
        private OreoUtils() {
        }

        @TargetApi(value=26)
        static void setColorSpace(BitmapFactory.Options options, @Nullable ColorSpace colorSpace) {
            options.inPreferredColorSpace = colorSpace == null ? ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB) : colorSpace;
        }
    }
}

