/* The following code was generated by JFlex 1.4.1 on 9/19/15 11:19 PM */

/*
 * 09/03/2005
 *
 * CSSTokenMaker.java - Token maker for CSS 3 files.
 *
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * This class splits up text into tokens representing a CSS 3 file.  It's
 * written with a few extra internal states so that it can easily be copy
 * and pasted into HTML, PHP, and JSP TokenMakres when it is updated.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>CSSTokenMaker.java</code> file will contain 2
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class CSSTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int CSS_C_STYLE_COMMENT = 5;
  public static final int LESS_EOL_COMMENT = 6;
  public static final int YYINITIAL = 0;
  public static final int CSS_STRING = 3;
  public static final int CSS_VALUE = 2;
  public static final int CSS_PROPERTY = 1;
  public static final int CSS_CHAR_LITERAL = 4;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\41\1\64\25\0\1\41\1\53\1\60\1\37\1\55\1\46"+
    "\1\50\1\61\1\44\1\65\1\5\1\54\1\57\1\4\1\6\1\42"+
    "\12\1\1\7\1\40\1\0\1\54\1\63\1\51\1\35\6\47\24\2"+
    "\1\52\1\43\1\52\1\63\1\3\1\0\1\21\1\34\1\15\1\20"+
    "\1\26\1\23\1\33\1\14\1\16\1\2\1\30\1\17\1\27\1\13"+
    "\1\11\1\25\1\2\1\10\1\22\1\12\1\32\1\31\1\36\1\45"+
    "\1\24\1\2\1\56\1\63\1\62\1\54\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\4\0\1\2\1\3\2\4\1\5\2\2"+
    "\1\6\1\7\1\2\1\10\1\11\1\1\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\2\20\1\21\3\16\1\22"+
    "\1\23\1\24\1\25\1\26\2\1\2\25\1\27\1\1"+
    "\1\30\1\25\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\33\1\37\1\40\5\33\1\41\4\33\1\42\2\0"+
    "\1\3\3\0\1\4\15\0\12\43\1\3\1\44\1\3"+
    "\1\45\1\46\2\0\1\47\1\50\1\51\2\0\1\26"+
    "\3\0\1\26\1\52\1\0\1\34\1\53\33\0\11\43"+
    "\15\0\1\17\16\0\1\17\14\0\11\43\26\0\1\54"+
    "\2\0\1\55\14\0\5\43\1\56\2\43\5\0\1\20"+
    "\31\0\6\43\21\0\3\43\14\0\2\43\7\0\1\43"+
    "\11\0\1\57\3\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[340];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\66\0\154\0\242\0\330\0\u010e\0\u0144\0\u017a"+
    "\0\u01b0\0\u01e6\0\u021c\0\u0252\0\u0288\0\u02be\0\u017a\0\u02f4"+
    "\0\u032a\0\u017a\0\u017a\0\u017a\0\u017a\0\u017a\0\u017a\0\u017a"+
    "\0\u017a\0\u0360\0\u0396\0\u03cc\0\u017a\0\u0402\0\u0438\0\u046e"+
    "\0\u017a\0\u017a\0\u017a\0\u017a\0\u04a4\0\u04da\0\u0510\0\u0402"+
    "\0\u0546\0\u017a\0\u057c\0\u017a\0\u05b2\0\u017a\0\u017a\0\u05e8"+
    "\0\u061e\0\u017a\0\u017a\0\u0654\0\u017a\0\u017a\0\u068a\0\u06c0"+
    "\0\u06f6\0\u072c\0\u0762\0\u017a\0\u0798\0\u07ce\0\u0804\0\u083a"+
    "\0\u017a\0\u0870\0\u08a6\0\u017a\0\u08dc\0\u0912\0\u0948\0\u097e"+
    "\0\u09b4\0\u09ea\0\u0a20\0\u0a56\0\u0a8c\0\u0ac2\0\u0af8\0\u0b2e"+
    "\0\u0b64\0\u0b9a\0\u0bd0\0\u0c06\0\u0c3c\0\u0c72\0\u0ca8\0\u0cde"+
    "\0\u0d14\0\u0d4a\0\u0d80\0\u0db6\0\u0dec\0\u0e22\0\u0e58\0\u0e8e"+
    "\0\u0ec4\0\u0efa\0\u017a\0\u017a\0\u0f30\0\u0f66\0\u0f9c\0\u017a"+
    "\0\u0fd2\0\u1008\0\u103e\0\u017a\0\u1074\0\u10aa\0\u10e0\0\u0546"+
    "\0\u04da\0\u1116\0\u017a\0\u017a\0\u114c\0\u1182\0\u11b8\0\u11ee"+
    "\0\u1224\0\u125a\0\u1290\0\u12c6\0\u12fc\0\u1332\0\u1368\0\u139e"+
    "\0\u13d4\0\u140a\0\u1440\0\u1476\0\u14ac\0\u14e2\0\u1518\0\u154e"+
    "\0\u1584\0\u15ba\0\u15f0\0\u1626\0\u165c\0\u1692\0\u16c8\0\u16fe"+
    "\0\u1734\0\u176a\0\u17a0\0\u17d6\0\u180c\0\u1842\0\u1878\0\u18ae"+
    "\0\u18e4\0\u191a\0\u1950\0\u1986\0\u19bc\0\u19f2\0\u1a28\0\u1a5e"+
    "\0\u1a94\0\u1aca\0\u1b00\0\u1b36\0\u1b6c\0\u1ba2\0\u1bd8\0\u1c0e"+
    "\0\u1c44\0\u1c7a\0\u1cb0\0\u1ce6\0\u1d1c\0\u1d52\0\u1d88\0\u1dbe"+
    "\0\u1df4\0\u1e2a\0\u1e60\0\u1e96\0\u017a\0\u1ecc\0\u1f02\0\u1f38"+
    "\0\u1f6e\0\u1fa4\0\u1fda\0\u2010\0\u2046\0\u207c\0\u20b2\0\u20e8"+
    "\0\u211e\0\u2154\0\u218a\0\u21c0\0\u21f6\0\u222c\0\u2262\0\u2298"+
    "\0\u22ce\0\u2304\0\u233a\0\u2370\0\u23a6\0\u23dc\0\u2412\0\u2448"+
    "\0\u247e\0\u24b4\0\u24ea\0\u2520\0\u2556\0\u258c\0\u25c2\0\u25f8"+
    "\0\u262e\0\u2664\0\u269a\0\u26d0\0\u2706\0\u273c\0\u2772\0\u27a8"+
    "\0\u27de\0\u2814\0\u284a\0\u2880\0\u28b6\0\u28ec\0\u2922\0\u2958"+
    "\0\u298e\0\u29c4\0\u29fa\0\u2a30\0\u2a66\0\u2a9c\0\u2ad2\0\u2b08"+
    "\0\u2b3e\0\u2b74\0\u2baa\0\u2be0\0\u2c16\0\u0c72\0\u2c4c\0\u2c82"+
    "\0\u2cb8\0\u2cee\0\u2d24\0\u2d5a\0\u2d90\0\u2dc6\0\u2dfc\0\u2e32"+
    "\0\u2e68\0\u2e9e\0\u2ed4\0\u2f0a\0\u2f40\0\u2f76\0\u2fac\0\u2fe2"+
    "\0\u3018\0\u304e\0\u3084\0\u30ba\0\u27de\0\u30f0\0\u2880\0\u3126"+
    "\0\u315c\0\u3192\0\u31c8\0\u31fe\0\u3234\0\u326a\0\u32a0\0\u32d6"+
    "\0\u330c\0\u3342\0\u3378\0\u33ae\0\u33e4\0\u341a\0\u3450\0\u3486"+
    "\0\u34bc\0\u34f2\0\u3528\0\u355e\0\u3594\0\u35ca\0\u3600\0\u3636"+
    "\0\u366c\0\u36a2\0\u36d8\0\u370e\0\u3744\0\u377a\0\u37b0\0\u37e6"+
    "\0\u381c\0\u3852\0\u3888\0\u38be\0\u38f4\0\u392a\0\u3960\0\u3996"+
    "\0\u39cc\0\u3a02\0\u3a38\0\u3a6e\0\u3aa4\0\u3ada\0\u3b10\0\u3b46"+
    "\0\u3b7c\0\u3bb2\0\u3be8\0\u3c1e\0\u3c54\0\u3c8a\0\u3cc0\0\u3cf6"+
    "\0\u3d2c\0\u3d62\0\u3d98\0\u3dce\0\u3e04\0\u3e3a\0\u3e70\0\u3ea6"+
    "\0\u017a\0\u3edc\0\u3f12\0\u3f48";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[340];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\10\1\11\2\12\1\13\2\12\1\14\25\12\1\15"+
    "\1\12\1\16\1\17\1\20\1\21\1\10\1\17\1\12"+
    "\1\10\1\12\2\10\1\17\1\10\2\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\22\1\30\1\17\2\31\3\32"+
    "\1\33\1\34\1\35\25\32\1\36\1\32\2\31\1\20"+
    "\1\37\2\31\1\32\1\31\1\32\1\40\5\31\1\41"+
    "\3\31\1\42\1\31\1\43\1\31\1\44\1\45\2\46"+
    "\1\47\1\44\1\24\1\44\25\46\1\50\1\46\1\51"+
    "\1\52\1\20\1\53\1\46\1\54\1\46\1\44\1\46"+
    "\3\44\1\55\3\44\1\24\1\25\1\26\1\42\1\44"+
    "\1\56\1\57\43\60\1\61\14\60\1\62\3\60\1\63"+
    "\1\60\43\64\1\61\15\64\1\65\2\64\1\66\1\64"+
    "\5\67\1\70\6\67\1\71\6\67\1\72\12\67\1\73"+
    "\25\67\1\74\1\67\14\75\1\76\6\75\1\77\12\75"+
    "\1\100\25\75\1\101\1\75\67\0\1\11\4\0\1\11"+
    "\6\0\1\102\1\103\3\0\1\104\2\0\1\105\1\106"+
    "\1\107\16\0\1\104\20\0\4\12\1\0\1\12\1\0"+
    "\25\12\1\0\1\12\6\0\1\12\1\0\1\12\17\0"+
    "\1\110\3\12\1\0\1\12\1\0\25\12\1\0\1\12"+
    "\6\0\1\12\1\0\1\12\25\0\1\111\1\112\1\113"+
    "\1\114\1\115\1\116\1\117\1\0\1\120\1\121\1\122"+
    "\1\0\1\123\2\0\1\124\2\0\1\125\36\0\3\126"+
    "\3\0\3\126\1\127\1\126\1\130\1\131\1\126\1\132"+
    "\2\126\1\133\1\126\1\134\1\126\1\135\1\136\1\137"+
    "\3\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\1\140\5\141\1\0\5\141\1\142\2\141\2\142\1\141"+
    "\1\142\2\141\1\142\5\141\1\142\1\0\1\141\6\0"+
    "\1\141\1\0\1\142\57\0\1\20\31\0\1\143\34\0"+
    "\1\144\24\0\4\32\1\0\1\34\1\145\25\32\1\0"+
    "\1\32\6\0\1\32\1\0\1\32\17\0\1\34\3\32"+
    "\1\0\1\34\1\146\25\32\1\0\1\32\6\0\1\32"+
    "\1\0\1\32\17\0\4\34\1\0\1\34\1\146\25\34"+
    "\1\0\1\34\6\0\1\34\1\0\1\34\20\0\3\147"+
    "\3\0\25\147\1\0\1\147\6\0\1\147\1\0\1\147"+
    "\23\0\1\143\34\0\1\150\25\0\5\151\1\0\25\151"+
    "\1\0\1\151\6\0\1\151\1\0\1\151\17\0\1\45"+
    "\4\0\1\45\6\0\1\152\1\153\3\0\1\154\2\0"+
    "\1\155\1\156\1\157\16\0\1\154\21\0\3\46\3\0"+
    "\25\46\1\0\1\46\3\0\2\46\1\54\1\46\1\0"+
    "\1\46\17\0\1\45\3\46\3\0\25\46\1\0\1\46"+
    "\3\0\2\46\1\54\1\46\1\0\1\46\17\0\1\160"+
    "\13\0\1\160\2\0\2\160\1\0\1\160\2\0\1\160"+
    "\5\0\1\160\12\0\1\160\20\0\3\46\1\143\2\0"+
    "\25\46\1\0\1\46\3\0\1\161\1\46\1\54\1\46"+
    "\1\0\1\46\34\0\1\162\47\0\43\60\1\0\14\60"+
    "\1\0\3\60\1\0\1\60\64\163\1\0\1\163\43\64"+
    "\1\0\15\64\1\0\2\64\1\0\1\64\5\67\1\0"+
    "\6\67\1\0\6\67\1\0\12\67\1\0\25\67\1\0"+
    "\1\67\42\0\1\164\35\0\1\165\65\0\1\166\3\0"+
    "\1\167\105\0\1\170\27\0\14\75\1\0\6\75\1\0"+
    "\12\75\1\0\25\75\1\0\1\75\12\0\1\171\65\0"+
    "\1\172\3\0\1\173\105\0\1\174\56\0\1\104\51\0"+
    "\1\104\64\0\1\104\2\0\1\104\27\0\1\104\47\0"+
    "\1\104\15\0\1\104\42\0\1\104\4\0\1\104\37\0"+
    "\1\110\3\12\1\0\1\110\1\0\25\12\1\0\1\12"+
    "\6\0\1\12\1\104\1\12\37\0\1\175\1\0\1\176"+
    "\10\0\1\177\42\0\1\200\67\0\1\201\73\0\1\202"+
    "\55\0\1\203\1\204\64\0\1\205\70\0\1\206\67\0"+
    "\1\207\2\0\1\210\62\0\1\211\64\0\1\212\61\0"+
    "\1\213\4\0\1\214\62\0\1\215\13\0\1\216\54\0"+
    "\1\217\50\0\4\126\1\0\1\126\1\0\25\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\11\126\1\220\13\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\4\126\1\221\20\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\17\126\1\222"+
    "\5\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\4\126\1\0\1\126\1\0\1\126\1\223\23\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\1\126\1\224\23\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\11\126\1\225\13\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\16\126\1\226"+
    "\6\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\4\126\1\0\1\126\1\0\16\126\1\227\6\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\6\126\1\230\16\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\1\140\13\0\1\140\2\0"+
    "\2\140\1\0\1\140\2\0\1\140\5\0\1\140\12\0"+
    "\1\140\17\0\4\141\1\0\1\141\1\0\25\141\1\0"+
    "\1\141\6\0\1\141\1\0\1\141\17\0\1\142\3\141"+
    "\1\0\1\141\1\0\5\141\1\142\2\141\2\142\1\141"+
    "\1\142\2\141\1\142\5\141\1\142\1\0\1\141\6\0"+
    "\1\141\1\0\1\142\25\0\1\231\1\232\1\233\1\234"+
    "\1\235\1\236\1\237\1\0\1\240\1\241\1\242\1\0"+
    "\1\243\2\0\1\244\2\0\1\245\4\0\1\246\36\0"+
    "\1\231\1\232\1\233\1\234\1\235\1\236\1\237\1\0"+
    "\1\240\1\241\1\242\1\0\1\243\2\0\1\244\2\0"+
    "\1\245\35\0\4\147\1\0\1\147\1\0\25\147\1\0"+
    "\1\147\6\0\1\147\1\0\1\147\17\0\4\151\1\0"+
    "\1\151\1\0\25\151\1\0\1\151\6\0\1\151\1\0"+
    "\1\151\45\0\1\154\51\0\1\154\64\0\1\154\2\0"+
    "\1\154\27\0\1\154\47\0\1\154\15\0\1\154\42\0"+
    "\1\154\4\0\1\154\65\0\1\247\50\0\1\250\100\0"+
    "\1\251\57\0\1\252\104\0\1\253\41\0\1\254\100\0"+
    "\1\255\57\0\1\256\104\0\1\257\52\0\1\260\60\0"+
    "\1\261\75\0\1\262\50\0\1\203\73\0\1\263\56\0"+
    "\1\264\67\0\1\265\67\0\1\266\102\0\1\267\62\0"+
    "\1\270\52\0\1\271\65\0\1\272\6\0\1\273\65\0"+
    "\1\215\55\0\1\274\70\0\1\275\60\0\1\276\76\0"+
    "\1\277\71\0\1\300\62\0\1\301\44\0\4\126\1\0"+
    "\1\126\1\0\17\126\1\302\5\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\11\126\1\303\13\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\15\126\1\304"+
    "\7\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\4\126\1\0\1\126\1\0\5\126\1\305\17\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\3\126\1\306\21\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\23\126\1\307\1\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\10\126\1\310"+
    "\14\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\4\126\1\0\1\126\1\0\14\126\1\311\10\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\16\126\1\312\6\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\37\0\1\313\1\0\1\314\10\0"+
    "\1\315\42\0\1\316\67\0\1\317\73\0\1\320\55\0"+
    "\1\321\1\322\64\0\1\323\70\0\1\324\67\0\1\325"+
    "\2\0\1\326\62\0\1\327\64\0\1\330\61\0\1\331"+
    "\4\0\1\332\62\0\1\333\13\0\1\334\54\0\1\335"+
    "\105\0\1\246\54\0\1\336\65\0\1\337\47\0\1\340"+
    "\104\0\1\251\45\0\1\341\104\0\1\342\47\0\1\343"+
    "\104\0\1\255\45\0\1\344\71\0\1\267\63\0\1\345"+
    "\100\0\1\346\66\0\1\347\74\0\1\350\36\0\1\351"+
    "\107\0\1\352\54\0\1\353\100\0\1\265\70\0\1\265"+
    "\44\0\1\347\71\0\1\354\101\0\1\355\55\0\1\273"+
    "\77\0\1\356\43\0\1\357\71\0\1\360\50\0\4\126"+
    "\1\0\1\126\1\0\16\126\1\361\6\126\1\0\1\126"+
    "\6\0\1\126\1\0\1\126\17\0\4\126\1\0\1\126"+
    "\1\0\1\362\24\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\1\126\1\363"+
    "\23\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\4\126\1\0\1\126\1\0\22\126\1\364\2\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\2\126\1\365\22\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\16\126\1\366\6\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\6\126\1\367"+
    "\16\126\1\0\1\126\6\0\1\126\1\0\1\126\17\0"+
    "\4\126\1\0\1\126\1\0\13\126\1\370\11\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\25\126\1\0\1\222\6\0\1\126\1\0"+
    "\1\126\41\0\1\371\60\0\1\372\75\0\1\373\50\0"+
    "\1\321\73\0\1\374\56\0\1\375\67\0\1\376\67\0"+
    "\1\377\102\0\1\u0100\62\0\1\u0101\52\0\1\u0102\65\0"+
    "\1\u0103\6\0\1\u0104\65\0\1\333\55\0\1\u0105\70\0"+
    "\1\u0106\60\0\1\u0107\76\0\1\u0108\71\0\1\u0109\62\0"+
    "\1\u010a\54\0\1\u010b\63\0\1\340\12\0\1\251\105\0"+
    "\1\u010c\24\0\2\341\5\u010d\25\341\1\u010d\1\341\2\u010d"+
    "\1\0\1\341\1\0\1\u010d\1\341\1\u010d\1\341\5\u010d"+
    "\1\341\1\0\1\u010d\1\0\1\u010d\3\0\1\u010d\7\0"+
    "\1\343\12\0\1\255\105\0\1\u010e\24\0\2\344\5\u010f"+
    "\25\344\1\u010f\1\344\2\u010f\1\0\1\344\1\0\1\u010f"+
    "\1\344\1\u010f\1\344\5\u010f\1\344\1\0\1\u010f\1\0"+
    "\1\u010f\3\0\1\u010f\22\0\1\u0110\54\0\1\u0111\60\0"+
    "\1\u0112\107\0\1\203\50\0\1\u0113\3\0\1\u0114\1\0"+
    "\1\u0115\56\0\1\265\105\0\1\u0116\66\0\1\u0117\56\0"+
    "\1\265\62\0\1\u0116\72\0\1\265\53\0\1\u0116\54\0"+
    "\4\126\1\0\1\126\1\0\12\126\1\u0118\12\126\1\0"+
    "\1\126\6\0\1\126\1\0\1\126\17\0\4\126\1\0"+
    "\1\126\1\0\12\126\1\u0119\12\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\1\u011a\24\126\1\0\1\126\6\0\1\126\1\0\1\126"+
    "\17\0\4\126\1\0\1\126\1\0\17\126\1\u011b\5\126"+
    "\1\0\1\126\6\0\1\126\1\0\1\126\17\0\3\126"+
    "\1\u011c\1\0\1\126\1\0\25\126\1\0\1\126\6\0"+
    "\1\126\1\0\1\126\17\0\4\126\1\0\1\126\1\0"+
    "\11\126\1\366\13\126\1\0\1\126\6\0\1\126\1\0"+
    "\1\126\17\0\4\126\1\0\1\126\1\0\1\u011d\24\126"+
    "\1\0\1\126\6\0\1\126\1\0\1\126\30\0\1\u0100"+
    "\63\0\1\u011e\100\0\1\u011f\66\0\1\u0120\74\0\1\u0121"+
    "\41\0\1\146\62\0\1\u0122\107\0\1\u0123\54\0\1\u0124"+
    "\100\0\1\376\70\0\1\376\44\0\1\u0120\71\0\1\u0125"+
    "\101\0\1\u0126\55\0\1\u0104\77\0\1\u0127\43\0\1\u0128"+
    "\71\0\1\u0129\57\0\1\u012a\117\0\1\341\65\0\1\344"+
    "\35\0\1\u012b\63\0\1\u0117\66\0\1\u0113\3\0\1\u0114"+
    "\73\0\1\u012c\56\0\1\u012d\72\0\1\276\72\0\1\u012e"+
    "\65\0\1\265\40\0\4\126\1\0\1\126\1\0\15\126"+
    "\1\u012f\7\126\1\0\1\126\6\0\1\126\1\0\1\126"+
    "\17\0\4\126\1\0\1\126\1\0\16\126\1\u011a\6\126"+
    "\1\0\1\126\6\0\1\126\1\0\1\126\17\0\4\126"+
    "\1\0\1\126\1\0\2\126\1\366\22\126\1\0\1\126"+
    "\6\0\1\126\1\0\1\126\17\0\4\126\1\0\1\126"+
    "\1\0\16\126\1\u0130\6\126\1\0\1\126\6\0\1\126"+
    "\1\0\1\126\17\0\4\126\1\0\1\126\1\0\13\126"+
    "\1\u012f\11\126\1\0\1\126\6\0\1\126\1\0\1\126"+
    "\17\0\4\126\1\0\1\126\1\0\11\126\1\u0131\13\126"+
    "\1\0\1\126\6\0\1\126\1\0\1\126\40\0\1\u0132"+
    "\54\0\1\u0133\60\0\1\u0134\107\0\1\321\50\0\1\u0135"+
    "\3\0\1\u0136\1\0\1\u0137\56\0\1\376\105\0\1\u0138"+
    "\66\0\1\u0139\56\0\1\376\62\0\1\u0138\72\0\1\376"+
    "\53\0\1\u0138\65\0\1\u013a\57\0\1\u013b\65\0\1\u013c"+
    "\77\0\1\u013d\67\0\1\265\46\0\4\126\1\0\1\126"+
    "\1\0\11\126\1\u013e\13\126\1\0\1\126\6\0\1\126"+
    "\1\0\1\126\17\0\4\126\1\0\1\126\1\0\3\126"+
    "\1\u011a\21\126\1\0\1\126\6\0\1\126\1\0\1\126"+
    "\17\0\4\126\1\0\1\126\1\0\17\126\1\u013f\5\126"+
    "\1\0\1\126\6\0\1\126\1\0\1\126\30\0\1\u0140"+
    "\63\0\1\u0139\66\0\1\u0135\3\0\1\u0136\73\0\1\u0141"+
    "\56\0\1\u0142\72\0\1\u0107\72\0\1\u0143\65\0\1\376"+
    "\60\0\1\u0144\63\0\1\u0145\60\0\1\u0146\72\0\1\u012e"+
    "\47\0\4\126\1\0\1\126\1\0\5\126\1\307\17\126"+
    "\1\0\1\126\6\0\1\126\1\0\1\126\17\0\4\126"+
    "\1\0\1\126\1\0\16\126\1\u0147\6\126\1\0\1\126"+
    "\6\0\1\126\1\0\1\126\22\0\1\u0148\65\0\1\u0149"+
    "\77\0\1\u014a\67\0\1\376\60\0\1\u014b\70\0\1\u014c"+
    "\7\0\1\u014d\63\0\1\u014e\42\0\4\126\1\0\1\126"+
    "\1\0\12\126\1\366\12\126\1\0\1\126\6\0\1\126"+
    "\1\0\1\126\35\0\1\u014f\60\0\1\u0150\72\0\1\u0143"+
    "\60\0\1\u0151\66\0\1\u0117\64\0\1\260\100\0\1\u0117"+
    "\56\0\1\u0152\7\0\1\u0153\63\0\1\u0154\54\0\1\u0139"+
    "\64\0\1\371\100\0\1\u0139\40\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[16254];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\1\4\0\1\11\6\1\1\11\2\1\10\11"+
    "\3\1\1\11\3\1\4\11\5\1\1\11\1\1\1\11"+
    "\1\1\2\11\2\1\2\11\1\1\2\11\5\1\1\11"+
    "\4\1\1\11\2\0\1\11\3\0\1\1\15\0\15\1"+
    "\2\11\2\0\1\1\1\11\1\1\2\0\1\11\3\0"+
    "\2\1\1\0\2\11\33\0\11\1\15\0\1\1\16\0"+
    "\1\11\14\0\11\1\26\0\1\1\2\0\1\1\14\0"+
    "\10\1\5\0\1\1\31\0\6\1\21\0\3\1\14\0"+
    "\2\1\7\0\1\1\11\0\1\11\3\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[340];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Internal type denoting a line ending in a CSS property.
	 */
	public static final int INTERNAL_CSS_PROPERTY			= -1;

	/**
	 * Internal type denoting a line ending in a CSS property value.
	 */
	public static final int INTERNAL_CSS_VALUE				= -2;

	/**
	 * Internal type denoting line ending in a CSS double-quote string.
	 * The state to return to is embedded in the actual end token type.
	 */
	public static final int INTERNAL_CSS_STRING				= -(1<<11);

	/**
	 * Internal type denoting line ending in a CSS single-quote string.
	 * The state to return to is embedded in the actual end token type.
	 */
	public static final int INTERNAL_CSS_CHAR				= -(2<<11);

	/**
	 * Internal type denoting line ending in a CSS multi-line comment.
	 * The state to return to is embedded in the actual end token type.
	 */
	public static final int INTERNAL_CSS_MLC				= -(3<<11);

	/**
	 * The state previous CSS-related state we were in before going into a CSS
	 * string, multi-line comment, etc.
	 */
	private int cssPrevState;

	/**
	 * Whether we are highlighting less instead of CSS.
	 */
	private boolean highlightingLess;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public CSSTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the closest {@link TokenTypes "standard" token type} for a given
	 * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
	 */
	@Override
	public int getClosestStandardTokenTypeForInternalType(int type) {
		switch (type) {
			case INTERNAL_CSS_STRING:
			case INTERNAL_CSS_CHAR:
				return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
			case INTERNAL_CSS_MLC:
				return TokenTypes.COMMENT_MULTILINE;
		}
		return type;
	}


	/**
	 * Returns <code>true</code> since CSS uses curly braces.
	 *
	 * @return <code>true</code> always.
	 */
	public boolean getCurlyBracesDenoteCodeBlocks() {
		return true;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return type==Token.RESERVED_WORD; // Used for CSS keys
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean getShouldIndentNextLineAfter(Token t) {
		if (t!=null && t.length()==1) {
			char ch = t.charAt(0);
			return ch=='{' || ch=='(';
		}
		return false;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		cssPrevState = YYINITIAL; // Shouldn't be necessary

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = CSS_STRING;
				break;
			case Token.LITERAL_CHAR:
				state = CSS_CHAR_LITERAL;
				break;
			case Token.COMMENT_MULTILINE:
				state = CSS_C_STYLE_COMMENT;
				break;
			case INTERNAL_CSS_PROPERTY:
				state = CSS_PROPERTY;
				break;
			case INTERNAL_CSS_VALUE:
				state = CSS_VALUE;
				break;
			default:
				if (initialTokenType<-1024) {
					int main = -(-initialTokenType & 0xffffff00);
					switch (main) {
						default: // Should never happen
						case INTERNAL_CSS_STRING:
							state = CSS_STRING;
							break;
						case INTERNAL_CSS_CHAR:
							state = CSS_CHAR_LITERAL;
							break;
						case INTERNAL_CSS_MLC:
							state = CSS_C_STYLE_COMMENT;
							break;
					}
					cssPrevState = -initialTokenType&0xff;
				}
				else {
					state = YYINITIAL;
				}
		}

		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Overridden to accept letters, digits, underscores, and hyphens.
	 */
	@Override
	public boolean isIdentifierChar(int languageIndex, char ch) {
		return Character.isLetterOrDigit(ch) || ch=='-' || ch=='.' || ch=='_';
	}


	/**
	 * Toggles whether we're highlighting less instead of just CSS.
	 *
	 * @param highlightingLess Whether we're highlighting less.
	 */
	public void setHighlightingLess(boolean highlightingLess) {
		this.highlightingLess = highlightingLess;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 134) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1:
          { addToken(Token.IDENTIFIER);
          }
        case 48: break;
        case 2:
          { /*System.out.println("yyinitial: " + yytext());*/ addToken(Token.IDENTIFIER);
          }
        case 49: break;
        case 25:
          { addEndToken(INTERNAL_CSS_VALUE); return firstToken;
          }
        case 50: break;
        case 16:
          { addToken(highlightingLess ? Token.RESERVED_WORD : Token.IDENTIFIER);
          }
        case 51: break;
        case 9:
          { addToken(Token.SEPARATOR); yybegin(CSS_PROPERTY);
          }
        case 52: break;
        case 29:
          { addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE); yybegin(cssPrevState);
          }
        case 53: break;
        case 32:
          { addToken(start,zzStartRead-1, Token.LITERAL_CHAR); addEndToken(INTERNAL_CSS_CHAR - cssPrevState); return firstToken;
          }
        case 54: break;
        case 37:
          { start = zzMarkedPos-2; cssPrevState = zzLexicalState; yybegin(CSS_C_STYLE_COMMENT);
          }
        case 55: break;
        case 31:
          { addToken(start,zzStartRead, Token.LITERAL_CHAR); yybegin(cssPrevState);
          }
        case 56: break;
        case 43:
          { addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE); yybegin(cssPrevState);
          }
        case 57: break;
        case 12:
          { addToken(highlightingLess ? Token.SEPARATOR : Token.IDENTIFIER);
          }
        case 58: break;
        case 10:
          { start = zzMarkedPos-1; cssPrevState = zzLexicalState; yybegin(CSS_STRING);
          }
        case 59: break;
        case 17:
          { addToken(Token.OPERATOR); yybegin(CSS_VALUE);
          }
        case 60: break;
        case 38:
          { if (highlightingLess) {
									start = zzMarkedPos-2; yybegin(LESS_EOL_COMMENT);
								}
								else { // Highlight the "//" as an identifier and continue on
									int temp = zzStartRead + 2;
									addToken(zzStartRead, zzStartRead + 1, Token.IDENTIFIER);
									zzStartRead = temp;
								}
          }
        case 61: break;
        case 5:
          { /* Unknown pseudo class */ addToken(Token.DATA_TYPE);
          }
        case 62: break;
        case 23:
          { addToken(Token.OPERATOR); yybegin(CSS_PROPERTY);
          }
        case 63: break;
        case 28:
          { /* Skip escaped chars. */
          }
        case 64: break;
        case 46:
          { addToken(Token.REGEX);
          }
        case 65: break;
        case 36:
          { addToken(highlightingLess ? Token.ANNOTATION : Token.VARIABLE);
          }
        case 66: break;
        case 3:
          { addToken(highlightingLess ? Token.LITERAL_NUMBER_DECIMAL_INT : Token.IDENTIFIER);
          }
        case 67: break;
        case 20:
          { addEndToken(INTERNAL_CSS_PROPERTY); return firstToken;
          }
        case 68: break;
        case 7:
          { addToken(Token.WHITESPACE);
          }
        case 69: break;
        case 19:
          { addToken(Token.SEPARATOR); yybegin(YYINITIAL);
          }
        case 70: break;
        case 47:
          { addToken(Token.PREPROCESSOR);
          }
        case 71: break;
        case 4:
          { addToken(Token.DATA_TYPE);
          }
        case 72: break;
        case 24:
          { int temp = zzMarkedPos - 2;
							  addToken(zzStartRead, temp, Token.FUNCTION);
							  addToken(zzMarkedPos-1, zzMarkedPos-1, Token.SEPARATOR);
							  zzStartRead = zzCurrentPos = zzMarkedPos;
          }
        case 73: break;
        case 35:
          { addToken(highlightingLess ? Token.VARIABLE : Token.REGEX);
          }
        case 74: break;
        case 18:
          { addToken(Token.SEPARATOR); /* helps with auto-closing curlies when editing CSS */
          }
        case 75: break;
        case 34:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL);
								switch (cssPrevState) {
									case CSS_PROPERTY:
										addEndToken(INTERNAL_CSS_PROPERTY);
										break;
									case CSS_VALUE:
										addEndToken(INTERNAL_CSS_VALUE);
										break;
									default: // Should be YYINITIAL
										addNullToken();
										break;
								}
								return firstToken;
          }
        case 76: break;
        case 22:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 77: break;
        case 30:
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_CSS_STRING - cssPrevState); return firstToken;
          }
        case 78: break;
        case 33:
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_CSS_MLC - cssPrevState); return firstToken;
          }
        case 79: break;
        case 26:
          { /* End of a function */ addToken(Token.SEPARATOR);
          }
        case 80: break;
        case 41:
          { if (highlightingLess) {
										// Unfortunately, as we're sharing the CSS and Less
										// syntax highlighting, we do not color nested selectors
										// properly.  For uniformity, color this the same as
										// CSS_Property
										addToken(Token.RESERVED_WORD);
									}
									else {
										addToken(Token.IDENTIFIER);
									}
          }
        case 81: break;
        case 39:
          { addToken(highlightingLess ? Token.VARIABLE : Token.IDENTIFIER);
          }
        case 82: break;
        case 14:
          { /*System.out.println("css_property: " + yytext());*/ addToken(Token.IDENTIFIER);
          }
        case 83: break;
        case 15:
          { addToken(Token.RESERVED_WORD);
          }
        case 84: break;
        case 44:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 85: break;
        case 11:
          { start = zzMarkedPos-1; cssPrevState = zzLexicalState; yybegin(CSS_CHAR_LITERAL);
          }
        case 86: break;
        case 6:
          { addToken(Token.SEPARATOR);
          }
        case 87: break;
        case 13:
          { addNullToken(); return firstToken;
          }
        case 88: break;
        case 40:
          { if (highlightingLess) {
									cssPrevState = zzLexicalState;
									start = zzMarkedPos-2; yybegin(LESS_EOL_COMMENT);
								}
								else { // Highlight the "//" as an identifier and continue on
									int temp = zzStartRead + 2;
									addToken(zzStartRead, zzStartRead + 1, Token.IDENTIFIER);
									zzStartRead = temp;
								}
          }
        case 89: break;
        case 8:
          { addToken(Token.OPERATOR);
          }
        case 90: break;
        case 21:
          { /*System.out.println("css_value: " + yytext());*/ addToken(Token.IDENTIFIER);
          }
        case 91: break;
        case 45:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 92: break;
        case 42:
          { // This must be before {CSS_Value} since "//" is a valid CSS value
								if (highlightingLess) {
									cssPrevState = zzLexicalState;
									start = zzMarkedPos-2; yybegin(LESS_EOL_COMMENT);
								}
								else { // Highlight the "//" as an identifier and continue on
									int temp = zzStartRead + 2;
									addToken(zzStartRead, zzStartRead + 1, Token.IDENTIFIER);
									zzStartRead = temp;
								}
          }
        case 93: break;
        case 27:
          {
          }
        case 94: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case CSS_C_STYLE_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_CSS_MLC - cssPrevState); return firstToken;
            }
            case 341: break;
            case LESS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL);
								switch (cssPrevState) {
									case CSS_PROPERTY:
										addEndToken(INTERNAL_CSS_PROPERTY);
										break;
									case CSS_VALUE:
										addEndToken(INTERNAL_CSS_VALUE);
										break;
									default: // Should be YYINITIAL
										addNullToken();
										break;
								}
								return firstToken;
            }
            case 342: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 343: break;
            case CSS_STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_CSS_STRING - cssPrevState); return firstToken;
            }
            case 344: break;
            case CSS_VALUE: {
              addEndToken(INTERNAL_CSS_VALUE); return firstToken;
            }
            case 345: break;
            case CSS_PROPERTY: {
              addEndToken(INTERNAL_CSS_PROPERTY); return firstToken;
            }
            case 346: break;
            case CSS_CHAR_LITERAL: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); addEndToken(INTERNAL_CSS_CHAR - cssPrevState); return firstToken;
            }
            case 347: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
