/*
 * Decompiled with CFR 0.152.
 */
package com.fiftyonred.mock_jedis;

import com.fiftyonred.mock_jedis.DataContainer;
import com.fiftyonred.mock_jedis.KeyType;
import com.fiftyonred.mock_jedis.MockStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.exceptions.JedisDataException;

public class MockPipeline
extends Pipeline {
    private static final byte[] STRING_TYPE = "string".getBytes(DataContainer.CHARSET);
    private static final byte[] LIST_TYPE = "list".getBytes(DataContainer.CHARSET);
    private static final byte[] SET_TYPE = "set".getBytes(DataContainer.CHARSET);
    private static final byte[] NONE_TYPE = "none".getBytes(DataContainer.CHARSET);
    private static final byte[] OK_RESPONSE = "OK".getBytes(DataContainer.CHARSET);
    private static final byte[] PONG_RESPONSE = "PONG".getBytes(DataContainer.CHARSET);
    private final MockStorage mockStorage = new MockStorage();

    public int getCurrentDB() {
        return this.mockStorage.getCurrentDB();
    }

    protected static <T> T getRandomElementFromSet(Set<T> set) {
        return (T)set.toArray()[(int)(Math.random() * (double)set.size())];
    }

    public Response<String> ping() {
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)PONG_RESPONSE);
        return response;
    }

    public Response<String> echo(String string) {
        Response response = new Response(BuilderFactory.STRING);
        response.set(this.echo(string.getBytes(DataContainer.CHARSET)).get());
        return response;
    }

    public Response<byte[]> echo(byte[] string) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        response.set((Object)string);
        return response;
    }

    public Response<Long> dbSize() {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.dbSize());
        return response;
    }

    public Response<String> flushAll() {
        this.mockStorage.flushAll();
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> flushDB() {
        this.mockStorage.flushDB();
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> rename(String oldkey, String newkey) {
        this.mockStorage.rename(DataContainer.from(oldkey), DataContainer.from(newkey));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        this.mockStorage.rename(DataContainer.from(oldkey), DataContainer.from(newkey));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<Long> renamenx(String oldkey, String newkey) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.renamenx(DataContainer.from(oldkey), DataContainer.from(newkey)) ? 1L : 0L));
        return response;
    }

    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.renamenx(DataContainer.from(oldkey), DataContainer.from(newkey)) ? 1L : 0L));
        return response;
    }

    public Response<String> set(String key, String value) {
        this.mockStorage.set(DataContainer.from(key), DataContainer.from(value));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> set(byte[] key, byte[] value) {
        this.mockStorage.set(DataContainer.from(key), DataContainer.from(value));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<Long> setnx(String key, String value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.setnx(DataContainer.from(key), DataContainer.from(value)) ? 1L : 0L));
        return response;
    }

    public Response<Long> setnx(byte[] key, byte[] value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.setnx(DataContainer.from(key), DataContainer.from(value)) ? 1L : 0L));
        return response;
    }

    public Response<String> get(String key) {
        Response response = new Response(BuilderFactory.STRING);
        DataContainer result = this.mockStorage.get(DataContainer.from(key));
        response.set((Object)DataContainer.toBytes(result));
        return response;
    }

    public Response<byte[]> get(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        DataContainer result = this.mockStorage.get(DataContainer.from(key));
        response.set((Object)DataContainer.toBytes(result));
        return response;
    }

    public Response<String> getSet(String key, String value) {
        Response response = new Response(BuilderFactory.STRING);
        DataContainer result = this.mockStorage.getSet(DataContainer.from(key), DataContainer.from(value));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<byte[]> getSet(byte[] key, byte[] value) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        DataContainer result = this.mockStorage.getSet(DataContainer.from(key), DataContainer.from(value));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<byte[]> dump(byte[] key) {
        return this.get(key);
    }

    public Response<byte[]> dump(String key) {
        return this.get(key.getBytes(DataContainer.CHARSET));
    }

    public Response<String> restore(String key, int ttl, byte[] serializedValue) {
        return this.setex(key.getBytes(DataContainer.CHARSET), ttl, serializedValue);
    }

    public Response<String> restore(byte[] key, int ttl, byte[] serializedValue) {
        return this.setex(key, ttl, serializedValue);
    }

    public Response<Boolean> exists(String key) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.mockStorage.exists(DataContainer.from(key)) ? 1L : 0L));
        return response;
    }

    public Response<Boolean> exists(byte[] key) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.mockStorage.exists(DataContainer.from(key)) ? 1L : 0L));
        return response;
    }

    public Response<String> type(String key) {
        KeyType type = this.mockStorage.type(DataContainer.from(key));
        Response response = new Response(BuilderFactory.STRING);
        if (type == null) {
            response.set((Object)NONE_TYPE);
            return response;
        }
        switch (type) {
            case STRING: {
                response.set((Object)STRING_TYPE);
                break;
            }
            case LIST: {
                response.set((Object)LIST_TYPE);
                break;
            }
            case SET: {
                response.set((Object)SET_TYPE);
                break;
            }
            default: {
                response.set((Object)NONE_TYPE);
            }
        }
        return response;
    }

    public Response<String> type(byte[] key) {
        KeyType type = this.mockStorage.type(DataContainer.from(key));
        Response response = new Response(BuilderFactory.STRING);
        if (type == null) {
            response.set((Object)NONE_TYPE);
            return response;
        }
        switch (type) {
            case STRING: {
                response.set((Object)STRING_TYPE);
                break;
            }
            case LIST: {
                response.set((Object)LIST_TYPE);
                break;
            }
            case SET: {
                response.set((Object)SET_TYPE);
                break;
            }
            default: {
                response.set((Object)NONE_TYPE);
            }
        }
        return response;
    }

    public Response<Long> move(String key, int dbIndex) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.move(DataContainer.from(key), dbIndex) ? 1L : 0L));
        return response;
    }

    public Response<Long> move(byte[] key, int dbIndex) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.move(DataContainer.from(key), dbIndex) ? 1L : 0L));
        return response;
    }

    public Response<String> randomKey() {
        DataContainer result = this.mockStorage.randomKey();
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<byte[]> randomKeyBinary() {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        DataContainer result = this.mockStorage.randomKey();
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<String> select(int dbIndex) {
        this.mockStorage.select(dbIndex);
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> setex(String key, int seconds, String value) {
        return this.psetex(key, seconds * 1000, value);
    }

    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        return this.psetex(key, seconds * 1000, value);
    }

    public Response<String> psetex(String key, int milliseconds, String value) {
        this.mockStorage.psetex(DataContainer.from(key), milliseconds, DataContainer.from(value));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> psetex(byte[] key, int milliseconds, byte[] value) {
        this.mockStorage.psetex(DataContainer.from(key), milliseconds, DataContainer.from(value));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<Long> expire(String key, int seconds) {
        return this.expireAt(key, System.currentTimeMillis() / 1000L + (long)seconds);
    }

    public Response<Long> expire(byte[] key, int seconds) {
        return this.expireAt(key, System.currentTimeMillis() / 1000L + (long)seconds);
    }

    public Response<Long> expireAt(String key, long unixTime) {
        return this.pexpireAt(key, unixTime * 1000L);
    }

    public Response<Long> expireAt(byte[] key, long unixTime) {
        return this.pexpireAt(key, unixTime * 1000L);
    }

    public Response<Long> pexpire(String key, int milliseconds) {
        return this.pexpireAt(key, System.currentTimeMillis() + (long)milliseconds);
    }

    public Response<Long> pexpire(byte[] key, int milliseconds) {
        return this.pexpireAt(key, System.currentTimeMillis() + (long)milliseconds);
    }

    public Response<Long> pexpire(String key, long milliseconds) {
        return this.pexpireAt(key, System.currentTimeMillis() + milliseconds);
    }

    public Response<Long> pexpire(byte[] key, long milliseconds) {
        return this.pexpireAt(key, System.currentTimeMillis() + milliseconds);
    }

    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.pexpireAt(DataContainer.from(key), millisecondsTimestamp) ? 1L : 0L));
        return response;
    }

    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.pexpireAt(DataContainer.from(key), millisecondsTimestamp) ? 1L : 0L));
        return response;
    }

    public Response<Long> ttl(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.ttl(DataContainer.from(key)));
        return response;
    }

    public Response<Long> ttl(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.ttl(DataContainer.from(key)));
        return response;
    }

    public Response<Long> append(String key, String value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.append(DataContainer.from(key), DataContainer.from(value)));
        return response;
    }

    public Response<Long> append(byte[] key, byte[] value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.append(DataContainer.from(key), DataContainer.from(value)));
        return response;
    }

    public Response<Long> pttl(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.pttl(DataContainer.from(key)));
        return response;
    }

    public Response<Long> pttl(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.pttl(DataContainer.from(key)));
        return response;
    }

    public Response<Long> persist(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.persist(DataContainer.from(key)) ? 1L : 0L));
        return response;
    }

    public Response<Long> persist(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.persist(DataContainer.from(key)) ? 1L : 0L));
        return response;
    }

    public Response<List<String>> mget(String ... keys) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>(keys.length);
        for (DataContainer val : this.mockStorage.mget(DataContainer.from(keys))) {
            result.add(val == null ? null : val.getBytes());
        }
        response.set(result);
        return response;
    }

    public Response<List<byte[]>> mget(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>(keys.length);
        for (DataContainer val : this.mockStorage.mget(DataContainer.from(keys))) {
            result.add(val == null ? null : val.getBytes());
        }
        response.set(result);
        return response;
    }

    public Response<String> mset(String ... keysvalues) {
        this.mockStorage.mset(DataContainer.from(keysvalues));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> mset(byte[] ... keysvalues) {
        this.mockStorage.mset(DataContainer.from(keysvalues));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<Long> msetnx(String ... keysvalues) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.msetnx(DataContainer.from(keysvalues)) ? 1L : 0L));
        return response;
    }

    public Response<Long> msetnx(byte[] ... keysvalues) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.msetnx(DataContainer.from(keysvalues)) ? 1L : 0L));
        return response;
    }

    public Response<Long> decr(String key) {
        return this.decrBy(key, 1L);
    }

    public Response<Long> decr(byte[] key) {
        return this.decrBy(key, 1L);
    }

    public Response<Long> decrBy(String key, long integer) {
        return this.incrBy(key, -integer);
    }

    public Response<Long> decrBy(byte[] key, long integer) {
        return this.incrBy(key, -integer);
    }

    public Response<Long> incr(String key) {
        return this.incrBy(key, 1L);
    }

    public Response<Long> incr(byte[] key) {
        return this.incrBy(key, 1L);
    }

    public Response<Long> incrBy(String key, long integer) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.incrBy(DataContainer.from(key), integer));
        return response;
    }

    public Response<Long> incrBy(byte[] key, long integer) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.incrBy(DataContainer.from(key), integer));
        return response;
    }

    public Response<Double> incrByFloat(String key, double increment) {
        Response response = new Response(BuilderFactory.DOUBLE);
        response.set((Object)this.mockStorage.incrByFloat(DataContainer.from(key), increment).getBytes());
        return response;
    }

    public Response<Double> incrByFloat(byte[] key, double increment) {
        Response response = new Response(BuilderFactory.DOUBLE);
        response.set((Object)this.mockStorage.incrByFloat(DataContainer.from(key), increment).getBytes());
        return response;
    }

    public Response<List<String>> sort(String key) {
        return this.sort(key, new SortingParams());
    }

    public Response<Long> sort(String key, String dstkey) {
        return this.sort(key, new SortingParams(), dstkey);
    }

    public Response<Long> sort(byte[] key, byte[] dstkey) {
        return this.sort(key, new SortingParams(), dstkey);
    }

    private static Comparator<DataContainer> makeComparator(Collection<String> params) {
        final int direction = params.contains(Protocol.Keyword.DESC.name().toLowerCase()) ? -1 : 1;
        Comparator<DataContainer> comparator = params.contains(Protocol.Keyword.ALPHA.name().toLowerCase()) ? new Comparator<DataContainer>(){

            @Override
            public int compare(DataContainer o1, DataContainer o2) {
                return o1.compareTo(o2) * direction;
            }
        } : new Comparator<DataContainer>(){

            @Override
            public int compare(DataContainer o1, DataContainer o2) {
                Long i2;
                Long i1;
                try {
                    i1 = Long.parseLong(o1.getString());
                    i2 = Long.parseLong(o2.getString());
                }
                catch (NumberFormatException e) {
                    throw new JedisDataException("ERR One or more scores can't be converted into double");
                }
                return i1.compareTo(i2) * direction;
            }
        };
        return comparator;
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        List<DataContainer> sortedList = this.mockStorage.sort(DataContainer.from(key), sortingParameters);
        response.set(DataContainer.toBytes(sortedList));
        return response;
    }

    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        List<DataContainer> sortedList = this.mockStorage.sort(DataContainer.from(key), sortingParameters);
        response.set(DataContainer.toBytes(sortedList));
        return response;
    }

    public Response<Long> sort(String key, SortingParams sortingParameters, String dstkey) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sort(DataContainer.from(key), sortingParameters, DataContainer.from(dstkey)));
        return response;
    }

    public Response<Long> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sort(DataContainer.from(key), sortingParameters, DataContainer.from(dstkey)));
        return response;
    }

    public Response<List<byte[]>> sort(byte[] key) {
        return this.sort(key, new SortingParams());
    }

    public Response<Long> strlen(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.strlen(DataContainer.from(key)));
        return response;
    }

    public Response<Long> strlen(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.strlen(DataContainer.from(key)));
        return response;
    }

    public Response<Long> del(String ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        long result = 0L;
        for (String key : keys) {
            result += ((Long)this.del(key).get()).longValue();
        }
        response.set((Object)result);
        return response;
    }

    public Response<Long> del(byte[] ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        long result = 0L;
        for (byte[] key : keys) {
            result += ((Long)this.del(key).get()).longValue();
        }
        response.set((Object)result);
        return response;
    }

    public Response<Long> del(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.del(DataContainer.from(key)) ? 1L : 0L));
        return response;
    }

    public Response<Long> del(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.del(DataContainer.from(key)) ? 1L : 0L));
        return response;
    }

    public Response<String> hget(String key, String field) {
        Response response = new Response(BuilderFactory.STRING);
        DataContainer result = this.mockStorage.hget(DataContainer.from(key), DataContainer.from(field));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<byte[]> hget(byte[] key, byte[] field) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        DataContainer result = this.mockStorage.hget(DataContainer.from(key), DataContainer.from(field));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<Map<String, String>> hgetAll(String key) {
        Response response = new Response(BuilderFactory.STRING_MAP);
        Map<DataContainer, DataContainer> result = this.mockStorage.hgetAll(DataContainer.from(key));
        if (result != null) {
            ArrayList<byte[]> encodedResult = new ArrayList<byte[]>(result.size());
            for (Map.Entry<DataContainer, DataContainer> e : result.entrySet()) {
                encodedResult.add(e.getKey().getBytes());
                encodedResult.add(e.getValue().getBytes());
            }
            response.set(encodedResult);
        } else {
            response.set(new ArrayList(0));
        }
        return response;
    }

    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_MAP);
        Map<DataContainer, DataContainer> result = this.mockStorage.hgetAll(DataContainer.from(key));
        if (result != null) {
            ArrayList<byte[]> encodedResult = new ArrayList<byte[]>(result.size());
            for (Map.Entry<DataContainer, DataContainer> e : result.entrySet()) {
                encodedResult.add(e.getKey().getBytes());
                encodedResult.add(e.getValue().getBytes());
            }
            response.set(encodedResult);
        } else {
            response.set(new ArrayList(0));
        }
        return response;
    }

    public Response<Set<String>> hkeys(String key) {
        Response response = new Response(BuilderFactory.STRING_SET);
        Set<DataContainer> result = this.mockStorage.hkeys(DataContainer.from(key));
        response.set((Object)(result == null ? new ArrayList(0) : DataContainer.toBytes(result)));
        return response;
    }

    public Response<Set<byte[]>> hkeys(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        Set<DataContainer> result = this.mockStorage.hkeys(DataContainer.from(key));
        response.set((Object)(result == null ? new ArrayList(0) : DataContainer.toBytes(result)));
        return response;
    }

    public Response<List<String>> hvals(String key) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        Collection<DataContainer> result = this.mockStorage.hvals(DataContainer.from(key));
        response.set((Object)(result == null ? new ArrayList(0) : DataContainer.toBytes(result)));
        return response;
    }

    public Response<List<byte[]>> hvals(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        Collection<DataContainer> result = this.mockStorage.hvals(DataContainer.from(key));
        response.set((Object)(result == null ? new ArrayList(0) : DataContainer.toBytes(result)));
        return response;
    }

    public Response<Long> hset(String key, String field, String value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.hset(DataContainer.from(key), DataContainer.from(field), DataContainer.from(value)) ? 1L : 0L));
        return response;
    }

    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.hset(DataContainer.from(key), DataContainer.from(field), DataContainer.from(value)) ? 1L : 0L));
        return response;
    }

    public Response<Long> hsetnx(String key, String field, String value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.hsetnx(DataContainer.from(key), DataContainer.from(field), DataContainer.from(value)) ? 1L : 0L));
        return response;
    }

    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.hsetnx(DataContainer.from(key), DataContainer.from(field), DataContainer.from(value)) ? 1L : 0L));
        return response;
    }

    public Response<List<String>> hmget(String key, String ... fields) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>(fields.length);
        List<DataContainer> hash = this.mockStorage.hmget(DataContainer.from(key), DataContainer.from(fields));
        if (hash == null) {
            for (String ignored : fields) {
                result.add(null);
            }
        } else {
            for (DataContainer h : hash) {
                result.add(h == null ? null : h.getBytes());
            }
        }
        response.set(result);
        return response;
    }

    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        ArrayList<byte[]> result = new ArrayList<byte[]>(fields.length);
        List<DataContainer> hash = this.mockStorage.hmget(DataContainer.from(key), DataContainer.from(fields));
        if (hash == null) {
            for (byte[] ignored : fields) {
                result.add(null);
            }
        } else {
            for (DataContainer h : hash) {
                result.add(h == null ? null : h.getBytes());
            }
        }
        response.set(result);
        return response;
    }

    public Response<String> hmset(String key, Map<String, String> hash) {
        this.mockStorage.hmset(DataContainer.from(key), DataContainer.fromStringMap(hash));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.mockStorage.hmset(DataContainer.from(key), DataContainer.fromByteMap(hash));
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)OK_RESPONSE);
        return response;
    }

    public Response<Long> hincrBy(String key, String field, long value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.hincrBy(DataContainer.from(key), DataContainer.from(field), value));
        return response;
    }

    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.hincrBy(DataContainer.from(key), DataContainer.from(field), value));
        return response;
    }

    public Response<Double> hincrByFloat(String key, String field, double increment) {
        Response response = new Response(BuilderFactory.DOUBLE);
        response.set((Object)this.mockStorage.hincrByFloat(DataContainer.from(key), DataContainer.from(field), increment).getBytes());
        return response;
    }

    public Response<Double> hincrByFloat(byte[] key, byte[] field, double increment) {
        Response response = new Response(BuilderFactory.DOUBLE);
        response.set((Object)this.mockStorage.hincrByFloat(DataContainer.from(key), DataContainer.from(field), increment).getBytes());
        return response;
    }

    public Response<Long> hdel(String key, String ... field) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.hdel(DataContainer.from(key), DataContainer.from(field)));
        return response;
    }

    public Response<Long> hdel(byte[] key, byte[] ... field) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.hdel(DataContainer.from(key), DataContainer.from(field)));
        return response;
    }

    public Response<Boolean> hexists(String key, String field) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.mockStorage.hexists(DataContainer.from(key), DataContainer.from(field)) ? 1L : 0L));
        return response;
    }

    public Response<Boolean> hexists(byte[] key, byte[] field) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.mockStorage.hexists(DataContainer.from(key), DataContainer.from(field)) ? 1L : 0L));
        return response;
    }

    public Response<Long> hlen(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.hlen(DataContainer.from(key)));
        return response;
    }

    public Response<Long> hlen(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.hlen(DataContainer.from(key)));
        return response;
    }

    public Response<Long> lpush(String key, String ... string) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.lpush(DataContainer.from(key), DataContainer.from(string)));
        return response;
    }

    public Response<Long> lpush(byte[] key, byte[] ... string) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.lpush(DataContainer.from(key), DataContainer.from(string)));
        return response;
    }

    public Response<String> lpop(String key) {
        Response response = new Response(BuilderFactory.STRING);
        DataContainer result = this.mockStorage.lpop(DataContainer.from(key));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<byte[]> lpop(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        DataContainer result = this.mockStorage.lpop(DataContainer.from(key));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<Long> llen(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.llen(DataContainer.from(key)));
        return response;
    }

    public Response<Long> llen(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.llen(DataContainer.from(key)));
        return response;
    }

    public Response<List<String>> lrange(String key, long start, long end) {
        Response response = new Response(BuilderFactory.STRING_LIST);
        response.set(DataContainer.toBytes(this.mockStorage.lrange(DataContainer.from(key), start, end)));
        return response;
    }

    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_LIST);
        response.set(DataContainer.toBytes(this.mockStorage.lrange(DataContainer.from(key), start, end)));
        return response;
    }

    public void sync() {
    }

    public Response<Set<String>> keys(String pattern) {
        Response response = new Response(BuilderFactory.STRING_SET);
        response.set(DataContainer.toBytes(this.mockStorage.keys(DataContainer.from(pattern))));
        return response;
    }

    public Response<Set<byte[]>> keys(byte[] pattern) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(DataContainer.toBytes(this.mockStorage.keys(DataContainer.from(pattern))));
        return response;
    }

    public Response<Long> sadd(String key, String ... member) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sadd(DataContainer.from(key), DataContainer.from(member)));
        return response;
    }

    public Response<Long> sadd(byte[] key, byte[] ... member) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sadd(DataContainer.from(key), DataContainer.from(member)));
        return response;
    }

    public Response<Long> srem(String key, String ... member) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.srem(DataContainer.from(key), DataContainer.from(member)));
        return response;
    }

    public Response<Long> srem(byte[] key, byte[] ... member) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.srem(DataContainer.from(key), DataContainer.from(member)));
        return response;
    }

    public Response<Long> scard(String key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.scard(DataContainer.from(key)));
        return response;
    }

    public Response<Long> scard(byte[] key) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.scard(DataContainer.from(key)));
        return response;
    }

    public Response<Set<String>> sdiff(String ... keys) {
        Response response = new Response(BuilderFactory.STRING_SET);
        response.set(DataContainer.toBytes(this.mockStorage.sdiff(DataContainer.from(keys))));
        return response;
    }

    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(DataContainer.toBytes(this.mockStorage.sdiff(DataContainer.from(keys))));
        return response;
    }

    public Response<Long> sdiffstore(String dstkey, String ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sdiffstore(DataContainer.from(dstkey), DataContainer.from(keys)));
        return response;
    }

    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sdiffstore(DataContainer.from(dstkey), DataContainer.from(keys)));
        return response;
    }

    public Response<Set<String>> sinter(String ... keys) {
        Response response = new Response(BuilderFactory.STRING_SET);
        response.set(DataContainer.toBytes(this.mockStorage.sinter(DataContainer.from(keys))));
        return response;
    }

    public Response<Set<byte[]>> sinter(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(DataContainer.toBytes(this.mockStorage.sinter(DataContainer.from(keys))));
        return response;
    }

    public Response<Long> sinterstore(String dstkey, String ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sinterstore(DataContainer.from(dstkey), DataContainer.from(keys)));
        return response;
    }

    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sinterstore(DataContainer.from(dstkey), DataContainer.from(keys)));
        return response;
    }

    public Response<Boolean> sismember(String key, String member) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.mockStorage.sismember(DataContainer.from(key), DataContainer.from(member)) ? 1L : 0L));
        return response;
    }

    public Response<Boolean> sismember(byte[] key, byte[] member) {
        Response response = new Response(BuilderFactory.BOOLEAN);
        response.set((Object)(this.mockStorage.sismember(DataContainer.from(key), DataContainer.from(member)) ? 1L : 0L));
        return response;
    }

    public Response<Long> smove(String srckey, String dstkey, String member) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.smove(DataContainer.from(srckey), DataContainer.from(dstkey), DataContainer.from(member)) ? 1L : 0L));
        return response;
    }

    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)(this.mockStorage.smove(DataContainer.from(srckey), DataContainer.from(dstkey), DataContainer.from(member)) ? 1L : 0L));
        return response;
    }

    public Response<String> spop(String key) {
        Response response = new Response(BuilderFactory.STRING);
        response.set((Object)DataContainer.toBytes(this.mockStorage.spop(DataContainer.from(key))));
        return response;
    }

    public Response<byte[]> spop(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        response.set((Object)DataContainer.toBytes(this.mockStorage.spop(DataContainer.from(key))));
        return response;
    }

    public Response<String> srandmember(String key) {
        Response response = new Response(BuilderFactory.STRING);
        DataContainer result = this.mockStorage.srandmember(DataContainer.from(key));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<byte[]> srandmember(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY);
        DataContainer result = this.mockStorage.srandmember(DataContainer.from(key));
        response.set((Object)(result == null ? null : result.getBytes()));
        return response;
    }

    public Response<Set<String>> smembers(String key) {
        Response response = new Response(BuilderFactory.STRING_SET);
        Set<DataContainer> members = this.mockStorage.smembers(DataContainer.from(key));
        response.set(DataContainer.toBytes(members));
        return response;
    }

    public Response<Set<byte[]>> smembers(byte[] key) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        Set<DataContainer> members = this.mockStorage.smembers(DataContainer.from(key));
        response.set(DataContainer.toBytes(members));
        return response;
    }

    public Response<Set<String>> sunion(String ... keys) {
        Response response = new Response(BuilderFactory.STRING_SET);
        response.set(DataContainer.toBytes(this.mockStorage.sunion(DataContainer.from(keys))));
        return response;
    }

    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        Response response = new Response(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(DataContainer.toBytes(this.mockStorage.sunion(DataContainer.from(keys))));
        return response;
    }

    public Response<Long> sunionstore(String dstkey, String ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sunionstore(DataContainer.from(dstkey), DataContainer.from(keys)));
        return response;
    }

    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        Response response = new Response(BuilderFactory.LONG);
        response.set((Object)this.mockStorage.sunionstore(DataContainer.from(dstkey), DataContainer.from(keys)));
        return response;
    }
}

