/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.CreditInterestTierBandSet;

@ApiModel(description="Details about the interest that may be payable to the BCA account holders")
public class CreditInterest {
    @JsonProperty(value="TierBandSet")
    private List<CreditInterestTierBandSet> tierBandSet = new ArrayList<CreditInterestTierBandSet>();

    public CreditInterest tierBandSet(List<CreditInterestTierBandSet> tierBandSet) {
        this.tierBandSet = tierBandSet;
        return this;
    }

    public CreditInterest addTierBandSetItem(CreditInterestTierBandSet tierBandSetItem) {
        this.tierBandSet.add(tierBandSetItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="The group of tiers or bands for which credit interest can be applied.")
    public List<CreditInterestTierBandSet> getTierBandSet() {
        return this.tierBandSet;
    }

    public void setTierBandSet(List<CreditInterestTierBandSet> tierBandSet) {
        this.tierBandSet = tierBandSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditInterest creditInterest = (CreditInterest)o;
        return Objects.equals(this.tierBandSet, creditInterest.tierBandSet);
    }

    public int hashCode() {
        return Objects.hash(this.tierBandSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditInterest {\n");
        sb.append("    tierBandSet: ").append(this.toIndentedString(this.tierBandSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

