/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.CreditInterest1TierBand;

@ApiModel(description="The group of tiers or bands for which credit interest can be applied.")
public class CreditInterest1TierBandSet {
    @JsonProperty(value="TierBandMethod")
    private TierBandMethodEnum tierBandMethod = null;
    @JsonProperty(value="CalculationMethod")
    private CalculationMethodEnum calculationMethod = null;
    @JsonProperty(value="Destination")
    private DestinationEnum destination = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="TierBand")
    private List<CreditInterest1TierBand> tierBand = new ArrayList<CreditInterest1TierBand>();

    public CreditInterest1TierBandSet tierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The methodology of how credit interest is charged. It can be:-  1. Banded Interest rates are banded. i.e. Increasing rate on whole balance as balance increases.  2. Tiered Interest rates are tiered. i.e. increasing rate for each tier as balance increases, but interest paid on tier fixed for that tier and not on whole balance.  3. Whole The same interest rate is applied irrespective of the PCA balance")
    public TierBandMethodEnum getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public CreditInterest1TierBandSet calculationMethod(CalculationMethodEnum calculationMethod) {
        this.calculationMethod = calculationMethod;
        return this;
    }

    @ApiModelProperty(value="Methods of calculating interest")
    public CalculationMethodEnum getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(CalculationMethodEnum calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public CreditInterest1TierBandSet destination(DestinationEnum destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(value="Describes whether accrued interest is payable only to the PCA or to another bank account")
    public DestinationEnum getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationEnum destination) {
        this.destination = destination;
    }

    public CreditInterest1TierBandSet notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public CreditInterest1TierBandSet addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band Set details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public CreditInterest1TierBandSet tierBand(List<CreditInterest1TierBand> tierBand) {
        this.tierBand = tierBand;
        return this;
    }

    public CreditInterest1TierBandSet addTierBandItem(CreditInterest1TierBand tierBandItem) {
        this.tierBand.add(tierBandItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="Tier Band Details")
    public List<CreditInterest1TierBand> getTierBand() {
        return this.tierBand;
    }

    public void setTierBand(List<CreditInterest1TierBand> tierBand) {
        this.tierBand = tierBand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditInterest1TierBandSet creditInterest1TierBandSet = (CreditInterest1TierBandSet)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)creditInterest1TierBandSet.tierBandMethod) && Objects.equals((Object)this.calculationMethod, (Object)creditInterest1TierBandSet.calculationMethod) && Objects.equals((Object)this.destination, (Object)creditInterest1TierBandSet.destination) && Objects.equals(this.notes, creditInterest1TierBandSet.notes) && Objects.equals(this.tierBand, creditInterest1TierBandSet.tierBand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.calculationMethod, this.destination, this.notes, this.tierBand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditInterest1TierBandSet {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    calculationMethod: ").append(this.toIndentedString((Object)this.calculationMethod)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    tierBand: ").append(this.toIndentedString(this.tierBand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationEnum {
        PAYAWAY("PayAway"),
        SELFCREDIT("SelfCredit");

        private String value;

        private DestinationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DestinationEnum fromValue(String text) {
            for (DestinationEnum b : DestinationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum CalculationMethodEnum {
        COMPOUND("Compound"),
        SIMPLEINTEREST("SimpleInterest");

        private String value;

        private CalculationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationMethodEnum fromValue(String text) {
            for (CalculationMethodEnum b : CalculationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TierBandMethodEnum {
        TIERED("Tiered"),
        WHOLE("Whole");

        private String value;

        private TierBandMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierBandMethodEnum fromValue(String text) {
            for (TierBandMethodEnum b : TierBandMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

