/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification4;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.account.OBExternalAccountSubType1Code;
import uk.org.openbanking.datamodel.account.OBExternalAccountType1Code;

@ApiModel(description="Unambiguous identification of the account to which credit and debit entries are made.")
@Validated
public class OBAccount2 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="Currency")
    private String currency = null;
    @JsonProperty(value="AccountType")
    private OBExternalAccountType1Code accountType = null;
    @JsonProperty(value="AccountSubType")
    private OBExternalAccountSubType1Code accountSubType = null;
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="Nickname")
    private String nickname = null;
    @JsonProperty(value="Account")
    @Valid
    private List<OBCashAccount3> account = null;
    @JsonProperty(value="Servicer")
    private OBBranchAndFinancialInstitutionIdentification4 servicer = null;

    public OBAccount2 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBAccount2 currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="Identification of the currency in which the account is held.  Usage: Currency should only be used in case one and the same account number covers several currencies and the initiating party needs to identify which currency needs to be used for settlement on the account.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public OBAccount2 accountType(OBExternalAccountType1Code accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalAccountType1Code getAccountType() {
        return this.accountType;
    }

    public void setAccountType(OBExternalAccountType1Code accountType) {
        this.accountType = accountType;
    }

    public OBAccount2 accountSubType(OBExternalAccountSubType1Code accountSubType) {
        this.accountSubType = accountSubType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalAccountSubType1Code getAccountSubType() {
        return this.accountSubType;
    }

    public void setAccountSubType(OBExternalAccountSubType1Code accountSubType) {
        this.accountSubType = accountSubType;
    }

    public OBAccount2 description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Specifies the description of the account type.")
    @Size(min=1, max=35)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBAccount2 nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(value="The nickname of the account, assigned by the account owner in order to provide an additional means of identification of the account.")
    @Size(min=1, max=70)
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public OBAccount2 account(List<OBCashAccount3> account) {
        this.account = account;
        return this;
    }

    public OBAccount2 addAccountItem(OBCashAccount3 accountItem) {
        if (this.account == null) {
            this.account = new ArrayList<OBCashAccount3>();
        }
        this.account.add(accountItem);
        return this;
    }

    @ApiModelProperty(value="Provides the details to identify an account.")
    @Valid
    public List<OBCashAccount3> getAccount() {
        return this.account;
    }

    public void setAccount(List<OBCashAccount3> account) {
        this.account = account;
    }

    public OBAccount2 servicer(OBBranchAndFinancialInstitutionIdentification4 servicer) {
        this.servicer = servicer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification4 getServicer() {
        return this.servicer;
    }

    public void setServicer(OBBranchAndFinancialInstitutionIdentification4 servicer) {
        this.servicer = servicer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBAccount2 obAccount2 = (OBAccount2)o;
        return Objects.equals(this.accountId, obAccount2.accountId) && Objects.equals(this.currency, obAccount2.currency) && Objects.equals((Object)this.accountType, (Object)obAccount2.accountType) && Objects.equals((Object)this.accountSubType, (Object)obAccount2.accountSubType) && Objects.equals(this.description, obAccount2.description) && Objects.equals(this.nickname, obAccount2.nickname) && Objects.equals(this.account, obAccount2.account) && Objects.equals(this.servicer, obAccount2.servicer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.currency, this.accountType, this.accountSubType, this.description, this.nickname, this.account, this.servicer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBAccount2 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    accountSubType: ").append(this.toIndentedString((Object)this.accountSubType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    servicer: ").append(this.toIndentedString(this.servicer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

