/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification5;
import uk.org.openbanking.datamodel.account.OBCashAccount5;
import uk.org.openbanking.datamodel.account.OBExternalAccountSubType1Code;
import uk.org.openbanking.datamodel.account.OBExternalAccountType1Code;

@ApiModel(description="Unambiguous identification of the account to which credit and debit entries are made.")
public class OBAccount3Detail {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="Currency")
    private String currency = null;
    @JsonProperty(value="AccountType")
    private OBExternalAccountType1Code accountType = null;
    @JsonProperty(value="AccountSubType")
    private OBExternalAccountSubType1Code accountSubType = null;
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="Nickname")
    private String nickname = null;
    @JsonProperty(value="Account")
    private List<OBCashAccount5> account = new ArrayList<OBCashAccount5>();
    @JsonProperty(value="Servicer")
    private OBBranchAndFinancialInstitutionIdentification5 servicer = null;

    public OBAccount3Detail accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBAccount3Detail currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    @ApiModelProperty(required=true, value="Identification of the currency in which the account is held.  Usage: Currency should only be used in case one and the same account number covers several currencies and the initiating party needs to identify which currency needs to be used for settlement on the account.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public OBAccount3Detail accountType(OBExternalAccountType1Code accountType) {
        this.accountType = accountType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalAccountType1Code getAccountType() {
        return this.accountType;
    }

    public void setAccountType(OBExternalAccountType1Code accountType) {
        this.accountType = accountType;
    }

    public OBAccount3Detail accountSubType(OBExternalAccountSubType1Code accountSubType) {
        this.accountSubType = accountSubType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalAccountSubType1Code getAccountSubType() {
        return this.accountSubType;
    }

    public void setAccountSubType(OBExternalAccountSubType1Code accountSubType) {
        this.accountSubType = accountSubType;
    }

    public OBAccount3Detail description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Specifies the description of the account type.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBAccount3Detail nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="The nickname of the account, assigned by the account owner in order to provide an additional means of identification of the account.")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public OBAccount3Detail account(List<OBCashAccount5> account) {
        this.account = account;
        return this;
    }

    public OBAccount3Detail addAccountItem(OBCashAccount5 accountItem) {
        this.account.add(accountItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Provides the details to identify an account.")
    public List<OBCashAccount5> getAccount() {
        return this.account;
    }

    public void setAccount(List<OBCashAccount5> account) {
        this.account = account;
    }

    public OBAccount3Detail servicer(OBBranchAndFinancialInstitutionIdentification5 servicer) {
        this.servicer = servicer;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification5 getServicer() {
        return this.servicer;
    }

    public void setServicer(OBBranchAndFinancialInstitutionIdentification5 servicer) {
        this.servicer = servicer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBAccount3Detail obAccount3Detail = (OBAccount3Detail)o;
        return Objects.equals(this.accountId, obAccount3Detail.accountId) && Objects.equals(this.currency, obAccount3Detail.currency) && Objects.equals((Object)this.accountType, (Object)obAccount3Detail.accountType) && Objects.equals((Object)this.accountSubType, (Object)obAccount3Detail.accountSubType) && Objects.equals(this.description, obAccount3Detail.description) && Objects.equals(this.nickname, obAccount3Detail.nickname) && Objects.equals(this.account, obAccount3Detail.account) && Objects.equals(this.servicer, obAccount3Detail.servicer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.currency, this.accountType, this.accountSubType, this.description, this.nickname, this.account, this.servicer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBAccount3Detail {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    accountSubType: ").append(this.toIndentedString((Object)this.accountSubType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    servicer: ").append(this.toIndentedString(this.servicer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

