/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification6;
import uk.org.openbanking.datamodel.account.OBCashAccount5;

public class OBBeneficiary3Detail {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="BeneficiaryId")
    private String beneficiaryId = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification6 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount5 creditorAccount = null;

    public OBBeneficiary3Detail accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBBeneficiary3Detail beneficiaryId(String beneficiaryId) {
        this.beneficiaryId = beneficiaryId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="A unique and immutable identifier used to identify the beneficiary resource. This identifier has no meaning to the account owner.")
    public String getBeneficiaryId() {
        return this.beneficiaryId;
    }

    public void setBeneficiaryId(String beneficiaryId) {
        this.beneficiaryId = beneficiaryId;
    }

    public OBBeneficiary3Detail reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBBeneficiary3Detail creditorAgent(OBBranchAndFinancialInstitutionIdentification6 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification6 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification6 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBBeneficiary3Detail creditorAccount(OBCashAccount5 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBCashAccount5 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount5 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBeneficiary3Detail obBeneficiary3Detail = (OBBeneficiary3Detail)o;
        return Objects.equals(this.accountId, obBeneficiary3Detail.accountId) && Objects.equals(this.beneficiaryId, obBeneficiary3Detail.beneficiaryId) && Objects.equals(this.reference, obBeneficiary3Detail.reference) && Objects.equals(this.creditorAgent, obBeneficiary3Detail.creditorAgent) && Objects.equals(this.creditorAccount, obBeneficiary3Detail.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.beneficiaryId, this.reference, this.creditorAgent, this.creditorAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBBeneficiary3Detail {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    beneficiaryId: ").append(this.toIndentedString(this.beneficiaryId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

