/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Party that manages the account on behalf of the account owner, that is manages the registration and booking of entries on the account, calculates balances on the account and provides information about the account. This is the servicer of the beneficiary account.")
@Validated
public class OBBranchAndFinancialInstitutionIdentification4 {
    @JsonProperty(value="SchemeName")
    private String schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;

    public OBBranchAndFinancialInstitutionIdentification4 schemeName(String schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the identification scheme, in a coded form as published in an external list.")
    @NotNull
    @Size(min=1, max=40)
    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public OBBranchAndFinancialInstitutionIdentification4 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique and unambiguous identification of the servicing institution.")
    @NotNull
    @Size(min=1, max=35)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBranchAndFinancialInstitutionIdentification4 obBranchAndFinancialInstitutionIdentification4 = (OBBranchAndFinancialInstitutionIdentification4)o;
        return Objects.equals(this.schemeName, obBranchAndFinancialInstitutionIdentification4.schemeName) && Objects.equals(this.identification, obBranchAndFinancialInstitutionIdentification4.identification);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.identification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBBranchAndFinancialInstitutionIdentification4 {\n");
        sb.append("    schemeName: ").append(this.toIndentedString(this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

