/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBPostalAddress6;

@ApiModel(description="Financial institution servicing an account for the debtor.")
public class OBBranchAndFinancialInstitutionIdentification6 {
    @JsonProperty(value="SchemeName")
    private String schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="PostalAddress")
    private OBPostalAddress6 postalAddress = null;

    public OBBranchAndFinancialInstitutionIdentification6 schemeName(String schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public OBBranchAndFinancialInstitutionIdentification6 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a financial institution or a branch of a financial institution.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBBranchAndFinancialInstitutionIdentification6 name(String name) {
        this.name = name;
        return this;
    }

    @Size(min=1, max=140)
    @ApiModelProperty(value="Name by which an agent is known and which is usually used to identify that agent.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBBranchAndFinancialInstitutionIdentification6 postalAddress(OBPostalAddress6 postalAddress) {
        this.postalAddress = postalAddress;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPostalAddress6 getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(OBPostalAddress6 postalAddress) {
        this.postalAddress = postalAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBranchAndFinancialInstitutionIdentification6 obBranchAndFinancialInstitutionIdentification6 = (OBBranchAndFinancialInstitutionIdentification6)o;
        return Objects.equals(this.schemeName, obBranchAndFinancialInstitutionIdentification6.schemeName) && Objects.equals(this.identification, obBranchAndFinancialInstitutionIdentification6.identification) && Objects.equals(this.name, obBranchAndFinancialInstitutionIdentification6.name) && Objects.equals(this.postalAddress, obBranchAndFinancialInstitutionIdentification6.postalAddress);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.identification, this.name, this.postalAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBBranchAndFinancialInstitutionIdentification6 {\n");
        sb.append("    schemeName: ").append(this.toIndentedString(this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    postalAddress: ").append(this.toIndentedString(this.postalAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

