/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalLimitType1Code;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Set of elements used to provide details on the credit line.")
@Validated
public class OBCreditLine1 {
    @JsonProperty(value="Included")
    private Boolean included = null;
    @JsonProperty(value="Type")
    private OBExternalLimitType1Code type = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;

    public OBCreditLine1 included(Boolean included) {
        this.included = included;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether or not the credit line is included in the balance of the account. Usage: If not present, credit line is not included in the balance amount of the account.")
    @NotNull
    public Boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(Boolean included) {
        this.included = included;
    }

    public OBCreditLine1 type(OBExternalLimitType1Code type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExternalLimitType1Code getType() {
        return this.type;
    }

    public void setType(OBExternalLimitType1Code type) {
        this.type = type;
    }

    public OBCreditLine1 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCreditLine1 obCreditLine1 = (OBCreditLine1)o;
        return Objects.equals(this.included, obCreditLine1.included) && Objects.equals((Object)this.type, (Object)obCreditLine1.type) && Objects.equals(this.amount, obCreditLine1.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.included, this.type, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCreditLine1 {\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

