/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Amount of money to be transferred between the debtor and creditor, before deduction of charges, expressed in the currency of the debtor's account, and to be transferred into a different currency.  Usage : Currency of the amount is expressed in the currency of the debtor's account, but the amount to be transferred is in another currency. The debtor agent will convert the amount and currency to the to be transferred amount and currency, eg, 'pay equivalent of 100000 EUR in JPY'(and account is in EUR).")
@Validated
public class OBEquivalentAmount {
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="CurrencyOfTransfer")
    private String currencyOfTransfer = null;

    public OBEquivalentAmount amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBEquivalentAmount currencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the currency of the to be transferred amount, which is different from the currency of the debtor's account.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getCurrencyOfTransfer() {
        return this.currencyOfTransfer;
    }

    public void setCurrencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBEquivalentAmount obTransaction2EquivalentAmount = (OBEquivalentAmount)o;
        return Objects.equals(this.amount, obTransaction2EquivalentAmount.amount) && Objects.equals(this.currencyOfTransfer, obTransaction2EquivalentAmount.currencyOfTransfer);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyOfTransfer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBEquivalentAmount {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyOfTransfer: ").append(this.toIndentedString(this.currencyOfTransfer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

