/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBLoanInterestTierBandSet1;

@ApiModel(description="Details about the interest that may be payable to the SME Loan holders")
public class OBLoanInterest1 {
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="LoanInterestTierBandSet")
    private List<OBLoanInterestTierBandSet1> loanInterestTierBandSet = new ArrayList<OBLoanInterestTierBandSet1>();

    public OBLoanInterest1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBLoanInterest1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the LoanInterest")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBLoanInterest1 loanInterestTierBandSet(List<OBLoanInterestTierBandSet1> loanInterestTierBandSet) {
        this.loanInterestTierBandSet = loanInterestTierBandSet;
        return this;
    }

    public OBLoanInterest1 addLoanInterestTierBandSetItem(OBLoanInterestTierBandSet1 loanInterestTierBandSetItem) {
        this.loanInterestTierBandSet.add(loanInterestTierBandSetItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="The group of tiers or bands for which debit interest can be applied.")
    public List<OBLoanInterestTierBandSet1> getLoanInterestTierBandSet() {
        return this.loanInterestTierBandSet;
    }

    public void setLoanInterestTierBandSet(List<OBLoanInterestTierBandSet1> loanInterestTierBandSet) {
        this.loanInterestTierBandSet = loanInterestTierBandSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBLoanInterest1 obLoanInterest1 = (OBLoanInterest1)o;
        return Objects.equals(this.notes, obLoanInterest1.notes) && Objects.equals(this.loanInterestTierBandSet, obLoanInterest1.loanInterestTierBandSet);
    }

    public int hashCode() {
        return Objects.hash(this.notes, this.loanInterestTierBandSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBLoanInterest1 {\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    loanInterestTierBandSet: ").append(this.toIndentedString(this.loanInterestTierBandSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

