/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBFeeFrequency1Code;
import uk.org.openbanking.datamodel.account.OBFeeType1Code;
import uk.org.openbanking.datamodel.account.OBMinMaxType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;

@ApiModel(description="Details about any caps (minimum/maximum charges) that apply to a particular fee/charge")
public class OBLoanInterestFeesChargeCap1 {
    @JsonProperty(value="FeeType")
    private List<OBFeeType1Code> feeType = new ArrayList<OBFeeType1Code>();
    @JsonProperty(value="MinMaxType")
    private OBMinMaxType1Code minMaxType = null;
    @JsonProperty(value="FeeCapOccurrence")
    private Integer feeCapOccurrence = null;
    @JsonProperty(value="FeeCapAmount")
    private Integer feeCapAmount = null;
    @JsonProperty(value="CappingPeriod")
    private OBFeeFrequency1Code cappingPeriod = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherFeeType")
    private List<OBOtherCodeType1> otherFeeType = null;

    public OBLoanInterestFeesChargeCap1 feeType(List<OBFeeType1Code> feeType) {
        this.feeType = feeType;
        return this;
    }

    public OBLoanInterestFeesChargeCap1 addFeeTypeItem(OBFeeType1Code feeTypeItem) {
        this.feeType.add(feeTypeItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="Fee/charge type which is being capped")
    public List<OBFeeType1Code> getFeeType() {
        return this.feeType;
    }

    public void setFeeType(List<OBFeeType1Code> feeType) {
        this.feeType = feeType;
    }

    public OBLoanInterestFeesChargeCap1 minMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBMinMaxType1Code getMinMaxType() {
        return this.minMaxType;
    }

    public void setMinMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
    }

    public OBLoanInterestFeesChargeCap1 feeCapOccurrence(Integer feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
        return this;
    }

    @ApiModelProperty(value="fee/charges are captured dependent on the number of occurrences rather than capped at a particular amount")
    public Integer getFeeCapOccurrence() {
        return this.feeCapOccurrence;
    }

    public void setFeeCapOccurrence(Integer feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
    }

    public OBLoanInterestFeesChargeCap1 feeCapAmount(Integer feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
        return this;
    }

    @ApiModelProperty(value="fee/charges are captured dependent on the number of occurrences rather than capped at a particular amount")
    public Integer getFeeCapAmount() {
        return this.feeCapAmount;
    }

    public void setFeeCapAmount(Integer feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
    }

    public OBLoanInterestFeesChargeCap1 cappingPeriod(OBFeeFrequency1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBFeeFrequency1Code getCappingPeriod() {
        return this.cappingPeriod;
    }

    public void setCappingPeriod(OBFeeFrequency1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
    }

    public OBLoanInterestFeesChargeCap1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBLoanInterestFeesChargeCap1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Free text for adding  extra details for fee charge cap")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBLoanInterestFeesChargeCap1 otherFeeType(List<OBOtherCodeType1> otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    public OBLoanInterestFeesChargeCap1 addOtherFeeTypeItem(OBOtherCodeType1 otherFeeTypeItem) {
        if (this.otherFeeType == null) {
            this.otherFeeType = new ArrayList<OBOtherCodeType1>();
        }
        this.otherFeeType.add(otherFeeTypeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Other fee type code which is not available in the standard code set")
    public List<OBOtherCodeType1> getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(List<OBOtherCodeType1> otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBLoanInterestFeesChargeCap1 obLoanInterestFeesChargeCap1 = (OBLoanInterestFeesChargeCap1)o;
        return Objects.equals(this.feeType, obLoanInterestFeesChargeCap1.feeType) && Objects.equals((Object)this.minMaxType, (Object)obLoanInterestFeesChargeCap1.minMaxType) && Objects.equals(this.feeCapOccurrence, obLoanInterestFeesChargeCap1.feeCapOccurrence) && Objects.equals(this.feeCapAmount, obLoanInterestFeesChargeCap1.feeCapAmount) && Objects.equals((Object)this.cappingPeriod, (Object)obLoanInterestFeesChargeCap1.cappingPeriod) && Objects.equals(this.notes, obLoanInterestFeesChargeCap1.notes) && Objects.equals(this.otherFeeType, obLoanInterestFeesChargeCap1.otherFeeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.minMaxType, this.feeCapOccurrence, this.feeCapAmount, this.cappingPeriod, this.notes, this.otherFeeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBLoanInterestFeesChargeCap1 {\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    minMaxType: ").append(this.toIndentedString((Object)this.minMaxType)).append("\n");
        sb.append("    feeCapOccurrence: ").append(this.toIndentedString(this.feeCapOccurrence)).append("\n");
        sb.append("    feeCapAmount: ").append(this.toIndentedString(this.feeCapAmount)).append("\n");
        sb.append("    cappingPeriod: ").append(this.toIndentedString((Object)this.cappingPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

