/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBInterestFixedVariableType1Code;
import uk.org.openbanking.datamodel.account.OBInterestRateType1Code;
import uk.org.openbanking.datamodel.account.OBLoanInterestFeesCharges1;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBPeriod1Code;

@ApiModel(description="Tier Band Details")
public class OBLoanInterestTierBand1 {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMinimum")
    private BigDecimal tierValueMinimum = null;
    @JsonProperty(value="TierValueMaximum")
    private BigDecimal tierValueMaximum = null;
    @JsonProperty(value="TierValueMinTerm")
    private BigDecimal tierValueMinTerm = null;
    @JsonProperty(value="MinTermPeriod")
    private OBPeriod1Code minTermPeriod = null;
    @JsonProperty(value="TierValueMaxTerm")
    private BigDecimal tierValueMaxTerm = null;
    @JsonProperty(value="MaxTermPeriod")
    private OBPeriod1Code maxTermPeriod = null;
    @JsonProperty(value="FixedVariableInterestRateType")
    private OBInterestFixedVariableType1Code fixedVariableInterestRateType = null;
    @JsonProperty(value="RepAPR")
    private BigDecimal repAPR = null;
    @JsonProperty(value="LoanProviderInterestRateType")
    private OBInterestRateType1Code loanProviderInterestRateType = null;
    @JsonProperty(value="LoanProviderInterestRate")
    private BigDecimal loanProviderInterestRate = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherLoanProviderInterestRateType")
    private OBOtherCodeType1 otherLoanProviderInterestRateType = null;
    @JsonProperty(value="LoanInterestFeesCharges")
    private List<OBLoanInterestFeesCharges1> loanInterestFeesCharges = null;

    public OBLoanInterestTierBand1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a SME Loan.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBLoanInterestTierBand1 tierValueMinimum(BigDecimal tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Minimum loan value for which the loan interest tier applies.")
    public BigDecimal getTierValueMinimum() {
        return this.tierValueMinimum;
    }

    public void setTierValueMinimum(BigDecimal tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
    }

    public OBLoanInterestTierBand1 tierValueMaximum(BigDecimal tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Minimum loan value for which the loan interest tier applies.")
    public BigDecimal getTierValueMaximum() {
        return this.tierValueMaximum;
    }

    public void setTierValueMaximum(BigDecimal tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
    }

    public OBLoanInterestTierBand1 tierValueMinTerm(BigDecimal tierValueMinTerm) {
        this.tierValueMinTerm = tierValueMinTerm;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Minimum loan value for which the loan interest tier applies.")
    public BigDecimal getTierValueMinTerm() {
        return this.tierValueMinTerm;
    }

    public void setTierValueMinTerm(BigDecimal tierValueMinTerm) {
        this.tierValueMinTerm = tierValueMinTerm;
    }

    public OBLoanInterestTierBand1 minTermPeriod(OBPeriod1Code minTermPeriod) {
        this.minTermPeriod = minTermPeriod;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBPeriod1Code getMinTermPeriod() {
        return this.minTermPeriod;
    }

    public void setMinTermPeriod(OBPeriod1Code minTermPeriod) {
        this.minTermPeriod = minTermPeriod;
    }

    public OBLoanInterestTierBand1 tierValueMaxTerm(BigDecimal tierValueMaxTerm) {
        this.tierValueMaxTerm = tierValueMaxTerm;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Minimum loan value for which the loan interest tier applies.")
    public BigDecimal getTierValueMaxTerm() {
        return this.tierValueMaxTerm;
    }

    public void setTierValueMaxTerm(BigDecimal tierValueMaxTerm) {
        this.tierValueMaxTerm = tierValueMaxTerm;
    }

    public OBLoanInterestTierBand1 maxTermPeriod(OBPeriod1Code maxTermPeriod) {
        this.maxTermPeriod = maxTermPeriod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPeriod1Code getMaxTermPeriod() {
        return this.maxTermPeriod;
    }

    public void setMaxTermPeriod(OBPeriod1Code maxTermPeriod) {
        this.maxTermPeriod = maxTermPeriod;
    }

    public OBLoanInterestTierBand1 fixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBInterestFixedVariableType1Code getFixedVariableInterestRateType() {
        return this.fixedVariableInterestRateType;
    }

    public void setFixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
    }

    public OBLoanInterestTierBand1 repAPR(BigDecimal repAPR) {
        this.repAPR = repAPR;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Minimum loan value for which the loan interest tier applies.")
    public BigDecimal getRepAPR() {
        return this.repAPR;
    }

    public void setRepAPR(BigDecimal repAPR) {
        this.repAPR = repAPR;
    }

    public OBLoanInterestTierBand1 loanProviderInterestRateType(OBInterestRateType1Code loanProviderInterestRateType) {
        this.loanProviderInterestRateType = loanProviderInterestRateType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBInterestRateType1Code getLoanProviderInterestRateType() {
        return this.loanProviderInterestRateType;
    }

    public void setLoanProviderInterestRateType(OBInterestRateType1Code loanProviderInterestRateType) {
        this.loanProviderInterestRateType = loanProviderInterestRateType;
    }

    public OBLoanInterestTierBand1 loanProviderInterestRate(BigDecimal loanProviderInterestRate) {
        this.loanProviderInterestRate = loanProviderInterestRate;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Minimum loan value for which the loan interest tier applies.")
    public BigDecimal getLoanProviderInterestRate() {
        return this.loanProviderInterestRate;
    }

    public void setLoanProviderInterestRate(BigDecimal loanProviderInterestRate) {
        this.loanProviderInterestRate = loanProviderInterestRate;
    }

    public OBLoanInterestTierBand1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBLoanInterestTierBand1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBLoanInterestTierBand1 otherLoanProviderInterestRateType(OBOtherCodeType1 otherLoanProviderInterestRateType) {
        this.otherLoanProviderInterestRateType = otherLoanProviderInterestRateType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType1 getOtherLoanProviderInterestRateType() {
        return this.otherLoanProviderInterestRateType;
    }

    public void setOtherLoanProviderInterestRateType(OBOtherCodeType1 otherLoanProviderInterestRateType) {
        this.otherLoanProviderInterestRateType = otherLoanProviderInterestRateType;
    }

    public OBLoanInterestTierBand1 loanInterestFeesCharges(List<OBLoanInterestFeesCharges1> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
        return this;
    }

    public OBLoanInterestTierBand1 addLoanInterestFeesChargesItem(OBLoanInterestFeesCharges1 loanInterestFeesChargesItem) {
        if (this.loanInterestFeesCharges == null) {
            this.loanInterestFeesCharges = new ArrayList<OBLoanInterestFeesCharges1>();
        }
        this.loanInterestFeesCharges.add(loanInterestFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Contains details of fees and charges which are not associated with either LoanRepayment or features/benefits")
    public List<OBLoanInterestFeesCharges1> getLoanInterestFeesCharges() {
        return this.loanInterestFeesCharges;
    }

    public void setLoanInterestFeesCharges(List<OBLoanInterestFeesCharges1> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBLoanInterestTierBand1 obLoanInterestTierBand1 = (OBLoanInterestTierBand1)o;
        return Objects.equals(this.identification, obLoanInterestTierBand1.identification) && Objects.equals(this.tierValueMinimum, obLoanInterestTierBand1.tierValueMinimum) && Objects.equals(this.tierValueMaximum, obLoanInterestTierBand1.tierValueMaximum) && Objects.equals(this.tierValueMinTerm, obLoanInterestTierBand1.tierValueMinTerm) && Objects.equals((Object)this.minTermPeriod, (Object)obLoanInterestTierBand1.minTermPeriod) && Objects.equals(this.tierValueMaxTerm, obLoanInterestTierBand1.tierValueMaxTerm) && Objects.equals((Object)this.maxTermPeriod, (Object)obLoanInterestTierBand1.maxTermPeriod) && Objects.equals((Object)this.fixedVariableInterestRateType, (Object)obLoanInterestTierBand1.fixedVariableInterestRateType) && Objects.equals(this.repAPR, obLoanInterestTierBand1.repAPR) && Objects.equals((Object)this.loanProviderInterestRateType, (Object)obLoanInterestTierBand1.loanProviderInterestRateType) && Objects.equals(this.loanProviderInterestRate, obLoanInterestTierBand1.loanProviderInterestRate) && Objects.equals(this.notes, obLoanInterestTierBand1.notes) && Objects.equals(this.otherLoanProviderInterestRateType, obLoanInterestTierBand1.otherLoanProviderInterestRateType) && Objects.equals(this.loanInterestFeesCharges, obLoanInterestTierBand1.loanInterestFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMinimum, this.tierValueMaximum, this.tierValueMinTerm, this.minTermPeriod, this.tierValueMaxTerm, this.maxTermPeriod, this.fixedVariableInterestRateType, this.repAPR, this.loanProviderInterestRateType, this.loanProviderInterestRate, this.notes, this.otherLoanProviderInterestRateType, this.loanInterestFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBLoanInterestTierBand1 {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMinimum: ").append(this.toIndentedString(this.tierValueMinimum)).append("\n");
        sb.append("    tierValueMaximum: ").append(this.toIndentedString(this.tierValueMaximum)).append("\n");
        sb.append("    tierValueMinTerm: ").append(this.toIndentedString(this.tierValueMinTerm)).append("\n");
        sb.append("    minTermPeriod: ").append(this.toIndentedString((Object)this.minTermPeriod)).append("\n");
        sb.append("    tierValueMaxTerm: ").append(this.toIndentedString(this.tierValueMaxTerm)).append("\n");
        sb.append("    maxTermPeriod: ").append(this.toIndentedString((Object)this.maxTermPeriod)).append("\n");
        sb.append("    fixedVariableInterestRateType: ").append(this.toIndentedString((Object)this.fixedVariableInterestRateType)).append("\n");
        sb.append("    repAPR: ").append(this.toIndentedString(this.repAPR)).append("\n");
        sb.append("    loanProviderInterestRateType: ").append(this.toIndentedString((Object)this.loanProviderInterestRateType)).append("\n");
        sb.append("    loanProviderInterestRate: ").append(this.toIndentedString(this.loanProviderInterestRate)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherLoanProviderInterestRateType: ").append(this.toIndentedString(this.otherLoanProviderInterestRateType)).append("\n");
        sb.append("    loanInterestFeesCharges: ").append(this.toIndentedString(this.loanInterestFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

