/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Size;

@ApiModel(description="Details of the merchant involved in the transaction.")
public class OBMerchantDetails1 {
    @JsonProperty(value="MerchantName")
    private String merchantName = null;
    @JsonProperty(value="MerchantCategoryCode")
    private String merchantCategoryCode = null;

    public OBMerchantDetails1 merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(value="Name by which the merchant is known.")
    @Size(min=1, max=350)
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public OBMerchantDetails1 merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(value="Category code conform to ISO 18245, related to the type of services or goods the merchant provides for the transaction.")
    @Size(min=3, max=4)
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBMerchantDetails1 data3MerchantDetails = (OBMerchantDetails1)o;
        return Objects.equals(this.merchantName, data3MerchantDetails.merchantName) && Objects.equals(this.merchantCategoryCode, data3MerchantDetails.merchantCategoryCode);
    }

    public int hashCode() {
        return Objects.hash(this.merchantName, this.merchantCategoryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Data3MerchantDetails {\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

