/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalOfferType1Code;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@Validated
public class OBOffer1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="OfferId")
    private String offerId = null;
    @JsonProperty(value="OfferType")
    private OBExternalOfferType1Code offerType = null;
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="StartDateTime")
    private DateTime startDateTime = null;
    @JsonProperty(value="EndDateTime")
    private DateTime endDateTime = null;
    @JsonProperty(value="Rate")
    private String rate = null;
    @JsonProperty(value="Value")
    private Integer value = null;
    @JsonProperty(value="Term")
    private String term = null;
    @JsonProperty(value="URL")
    private String URL = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="Fee")
    private OBActiveOrHistoricCurrencyAndAmount fee = null;

    public OBOffer1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBOffer1 offerId(String offerId) {
        this.offerId = offerId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the offer resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getOfferId() {
        return this.offerId;
    }

    public void setOfferId(String offerId) {
        this.offerId = offerId;
    }

    public OBOffer1 offerType(OBExternalOfferType1Code offerType) {
        this.offerType = offerType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExternalOfferType1Code getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OBExternalOfferType1Code offerType) {
        this.offerType = offerType;
    }

    public OBOffer1 description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Further details of the offer.")
    @Size(min=1, max=500)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBOffer1 startDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which the offer starts. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public OBOffer1 endDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which the offer ends. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public OBOffer1 rate(String rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="Rate associated with the offer type.")
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @Size(min=1, max=10)
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public OBOffer1 value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Value associated with the offer type.")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public OBOffer1 term(String term) {
        this.term = term;
        return this;
    }

    @ApiModelProperty(value="Further details of the term of the offer.")
    @Size(min=1, max=500)
    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public OBOffer1 URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @ApiModelProperty(value="URL (Uniform Resource Locator) where documentation on the offer can be found")
    @Size(min=1, max=256)
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public OBOffer1 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBOffer1 fee(OBActiveOrHistoricCurrencyAndAmount fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getFee() {
        return this.fee;
    }

    public void setFee(OBActiveOrHistoricCurrencyAndAmount fee) {
        this.fee = fee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOffer1 obOffer1 = (OBOffer1)o;
        return Objects.equals(this.accountId, obOffer1.accountId) && Objects.equals(this.offerId, obOffer1.offerId) && Objects.equals((Object)this.offerType, (Object)obOffer1.offerType) && Objects.equals(this.description, obOffer1.description) && Objects.equals(this.startDateTime, obOffer1.startDateTime) && Objects.equals(this.endDateTime, obOffer1.endDateTime) && Objects.equals(this.rate, obOffer1.rate) && Objects.equals(this.value, obOffer1.value) && Objects.equals(this.term, obOffer1.term) && Objects.equals(this.URL, obOffer1.URL) && Objects.equals(this.amount, obOffer1.amount) && Objects.equals(this.fee, obOffer1.fee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.offerId, this.offerType, this.description, this.startDateTime, this.endDateTime, this.rate, this.value, this.term, this.URL, this.amount, this.fee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOffer1 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    offerId: ").append(this.toIndentedString(this.offerId)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    term: ").append(this.toIndentedString(this.term)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

