/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBFeeCategory1Code;

@ApiModel(description="Other Fee/charge type which is not available in the standard code set")
@Validated
public class OBOtherFeeChargeDetailType {
    @JsonProperty(value="Code")
    private String code = null;
    @JsonProperty(value="FeeCategory")
    private OBFeeCategory1Code feeCategory = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="Description")
    private String description = null;

    public OBOtherFeeChargeDetailType code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="The four letter Mnemonic used within an XML file to identify a code")
    @Pattern(regexp="^\\w{0,4}$")
    @Size(min=0, max=4)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OBOtherFeeChargeDetailType feeCategory(OBFeeCategory1Code feeCategory) {
        this.feeCategory = feeCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="Categorisation of fees and charges into standard categories.")
    @NotNull
    public OBFeeCategory1Code getFeeCategory() {
        return this.feeCategory;
    }

    public void setFeeCategory(OBFeeCategory1Code feeCategory) {
        this.feeCategory = feeCategory;
    }

    public OBOtherFeeChargeDetailType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Long name associated with the code")
    @NotNull
    @Size(min=1, max=70)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBOtherFeeChargeDetailType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Description to describe the purpose of the code")
    @NotNull
    @Size(min=1, max=350)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOtherFeeChargeDetailType otherFeeType1 = (OBOtherFeeChargeDetailType)o;
        return Objects.equals(this.code, otherFeeType1.code) && Objects.equals((Object)this.feeCategory, (Object)otherFeeType1.feeCategory) && Objects.equals(this.name, otherFeeType1.name) && Objects.equals(this.description, otherFeeType1.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.feeCategory, this.name, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOtherFeeChargeDetailType {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    feeCategory: ").append(this.toIndentedString((Object)this.feeCategory)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

