/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBFeeChargeCap1;
import uk.org.openbanking.datamodel.account.OBFeeChargeDetail1;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBTariffType1Code;

@ApiModel(description="Contains details of fees and charges which are not associated with either Overdraft or features/benefits")
@Validated
public class OBOtherFeesAndCharges1 {
    @JsonProperty(value="TariffType")
    private OBTariffType1Code tariffType = null;
    @JsonProperty(value="TariffName")
    private String tariffName = null;
    @JsonProperty(value="OtherTariffType")
    private OBOtherCodeType1 otherTariffType = null;
    @JsonProperty(value="FeeChargeDetail")
    @Valid
    private List<OBFeeChargeDetail1> feeChargeDetail = new ArrayList<OBFeeChargeDetail1>();
    @JsonProperty(value="FeeChargeCap")
    @Valid
    private List<OBFeeChargeCap1> feeChargeCap = null;

    public OBOtherFeesAndCharges1 tariffType(OBTariffType1Code tariffType) {
        this.tariffType = tariffType;
        return this;
    }

    @ApiModelProperty(value="TariffType which defines the fee and charges.")
    public OBTariffType1Code getTariffType() {
        return this.tariffType;
    }

    public void setTariffType(OBTariffType1Code tariffType) {
        this.tariffType = tariffType;
    }

    public OBOtherFeesAndCharges1 tariffName(String tariffName) {
        this.tariffName = tariffName;
        return this;
    }

    @ApiModelProperty(value="Name of the tariff")
    @Size(min=1, max=350)
    public String getTariffName() {
        return this.tariffName;
    }

    public void setTariffName(String tariffName) {
        this.tariffName = tariffName;
    }

    public OBOtherFeesAndCharges1 otherTariffType(OBOtherCodeType1 otherTariffType) {
        this.otherTariffType = otherTariffType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherTariffType() {
        return this.otherTariffType;
    }

    public void setOtherTariffType(OBOtherCodeType1 otherTariffType) {
        this.otherTariffType = otherTariffType;
    }

    public OBOtherFeesAndCharges1 feeChargeDetail(List<OBFeeChargeDetail1> feeChargeDetail) {
        this.feeChargeDetail = feeChargeDetail;
        return this;
    }

    public OBOtherFeesAndCharges1 addFeeChargeDetailItem(OBFeeChargeDetail1 feeChargeDetailItem) {
        this.feeChargeDetail.add(feeChargeDetailItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Other fees/charges details")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBFeeChargeDetail1> getFeeChargeDetail() {
        return this.feeChargeDetail;
    }

    public void setFeeChargeDetail(List<OBFeeChargeDetail1> feeChargeDetail) {
        this.feeChargeDetail = feeChargeDetail;
    }

    public OBOtherFeesAndCharges1 feeChargeCap(List<OBFeeChargeCap1> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
        return this;
    }

    public OBOtherFeesAndCharges1 addFeeChargeCapItem(OBFeeChargeCap1 feeChargeCapItem) {
        if (this.feeChargeCap == null) {
            this.feeChargeCap = new ArrayList<OBFeeChargeCap1>();
        }
        this.feeChargeCap.add(feeChargeCapItem);
        return this;
    }

    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular or group of fee/charge")
    @Valid
    public List<OBFeeChargeCap1> getFeeChargeCap() {
        return this.feeChargeCap;
    }

    public void setFeeChargeCap(List<OBFeeChargeCap1> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOtherFeesAndCharges1 obBCAData1OtherFeesCharges = (OBOtherFeesAndCharges1)o;
        return Objects.equals((Object)this.tariffType, (Object)obBCAData1OtherFeesCharges.tariffType) && Objects.equals(this.tariffName, obBCAData1OtherFeesCharges.tariffName) && Objects.equals(this.otherTariffType, obBCAData1OtherFeesCharges.otherTariffType) && Objects.equals(this.feeChargeDetail, obBCAData1OtherFeesCharges.feeChargeDetail) && Objects.equals(this.feeChargeCap, obBCAData1OtherFeesCharges.feeChargeCap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tariffType, this.tariffName, this.otherTariffType, this.feeChargeDetail, this.feeChargeCap});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOtherFeesAndCharges1 {\n");
        sb.append("    tariffType: ").append(this.toIndentedString((Object)this.tariffType)).append("\n");
        sb.append("    tariffName: ").append(this.toIndentedString(this.tariffName)).append("\n");
        sb.append("    otherTariffType: ").append(this.toIndentedString(this.otherTariffType)).append("\n");
        sb.append("    feeChargeDetail: ").append(this.toIndentedString(this.feeChargeDetail)).append("\n");
        sb.append("    feeChargeCap: ").append(this.toIndentedString(this.feeChargeCap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

