/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBMinMaxType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBOverdraftFeeType1Code;
import uk.org.openbanking.datamodel.account.OBPeriod1Code;

@ApiModel(description="Details about any caps (maximum charges) that apply to a particular fee/charge. Capping can either be based on an amount (in gbp), an amount (in items) or a rate.")
@Validated
public class OBOverdraftFeeChargeCap1 {
    @JsonProperty(value="FeeType")
    @Valid
    private List<OBOverdraftFeeType1Code> feeType = new ArrayList<OBOverdraftFeeType1Code>();
    @JsonProperty(value="MinMaxType")
    private OBMinMaxType1Code minMaxType = null;
    @JsonProperty(value="FeeCapOccurrence")
    private Float feeCapOccurrence = null;
    @JsonProperty(value="FeeCapAmount")
    private String feeCapAmount = null;
    @JsonProperty(value="CappingPeriod")
    private OBPeriod1Code cappingPeriod = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="OtherFeeType")
    @Valid
    private List<OBOtherCodeType1> otherFeeType = null;

    public OBOverdraftFeeChargeCap1 feeType(List<OBOverdraftFeeType1Code> feeType) {
        this.feeType = feeType;
        return this;
    }

    public OBOverdraftFeeChargeCap1 addFeeTypeItem(OBOverdraftFeeType1Code feeTypeItem) {
        this.feeType.add(feeTypeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Fee/charge type which is being capped")
    @NotNull
    @Size(min=1)
    public List<OBOverdraftFeeType1Code> getFeeType() {
        return this.feeType;
    }

    public void setFeeType(List<OBOverdraftFeeType1Code> feeType) {
        this.feeType = feeType;
    }

    public OBOverdraftFeeChargeCap1 minMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
        return this;
    }

    @ApiModelProperty(required=true, value="Min Max type")
    @NotNull
    public OBMinMaxType1Code getMinMaxType() {
        return this.minMaxType;
    }

    public void setMinMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
    }

    public OBOverdraftFeeChargeCap1 feeCapOccurrence(Float feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the advertised overdraft rate is guaranteed to be offered to a borrower by the bank e.g. if it\u2019s part of a government scheme, or whether the rate may vary dependent on the applicant\u2019s circumstances.")
    public Float getFeeCapOccurrence() {
        return this.feeCapOccurrence;
    }

    public void setFeeCapOccurrence(Float feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
    }

    public OBOverdraftFeeChargeCap1 feeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
        return this;
    }

    @ApiModelProperty(value="Cap amount charged for a fee/charge")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getFeeCapAmount() {
        return this.feeCapAmount;
    }

    public void setFeeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
    }

    public OBOverdraftFeeChargeCap1 cappingPeriod(OBPeriod1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
        return this;
    }

    @ApiModelProperty(value="Period e.g. day, week, month etc. for which the fee/charge is capped")
    public OBPeriod1Code getCappingPeriod() {
        return this.cappingPeriod;
    }

    public void setCappingPeriod(OBPeriod1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
    }

    public OBOverdraftFeeChargeCap1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBOverdraftFeeChargeCap1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Notes related to Overdraft fee charge cap")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBOverdraftFeeChargeCap1 otherFeeType(List<OBOtherCodeType1> otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    public OBOverdraftFeeChargeCap1 addOtherFeeTypeItem(OBOtherCodeType1 otherFeeTypeItem) {
        if (this.otherFeeType == null) {
            this.otherFeeType = new ArrayList<OBOtherCodeType1>();
        }
        this.otherFeeType.add(otherFeeTypeItem);
        return this;
    }

    @ApiModelProperty(value="Other fee type code which is not available in the standard code set")
    @Valid
    public List<OBOtherCodeType1> getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(List<OBOtherCodeType1> otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOverdraftFeeChargeCap1 overdraft1OverdraftFeeChargeCap = (OBOverdraftFeeChargeCap1)o;
        return Objects.equals(this.feeType, overdraft1OverdraftFeeChargeCap.feeType) && Objects.equals((Object)this.minMaxType, (Object)overdraft1OverdraftFeeChargeCap.minMaxType) && Objects.equals(this.feeCapOccurrence, overdraft1OverdraftFeeChargeCap.feeCapOccurrence) && Objects.equals(this.feeCapAmount, overdraft1OverdraftFeeChargeCap.feeCapAmount) && Objects.equals((Object)this.cappingPeriod, (Object)overdraft1OverdraftFeeChargeCap.cappingPeriod) && Objects.equals(this.notes, overdraft1OverdraftFeeChargeCap.notes) && Objects.equals(this.otherFeeType, overdraft1OverdraftFeeChargeCap.otherFeeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.minMaxType, this.feeCapOccurrence, this.feeCapAmount, this.cappingPeriod, this.notes, this.otherFeeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOverdraftFeeChargeCap1 {\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    minMaxType: ").append(this.toIndentedString((Object)this.minMaxType)).append("\n");
        sb.append("    feeCapOccurrence: ").append(this.toIndentedString(this.feeCapOccurrence)).append("\n");
        sb.append("    feeCapAmount: ").append(this.toIndentedString(this.feeCapAmount)).append("\n");
        sb.append("    cappingPeriod: ").append(this.toIndentedString((Object)this.cappingPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

