/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBFeeFrequency1Code;
import uk.org.openbanking.datamodel.account.OBInterestRateType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBOverdraftFeeChargeCap1;
import uk.org.openbanking.datamodel.account.OBOverdraftFeeType1Code;

@ApiModel(description="Details about the fees/charges")
@Validated
public class OBOverdraftFeesChargeDetails1 {
    @JsonProperty(value="FeeType")
    private OBOverdraftFeeType1Code feeType = null;
    @JsonProperty(value="NegotiableIndicator")
    private Boolean negotiableIndicator = null;
    @JsonProperty(value="OverdraftControlIndicator")
    private Boolean overdraftControlIndicator = null;
    @JsonProperty(value="IncrementalBorrowingAmount")
    private String incrementalBorrowingAmount = null;
    @JsonProperty(value="FeeAmount")
    private String feeAmount = null;
    @JsonProperty(value="FeeRate")
    private String feeRate = null;
    @JsonProperty(value="FeeRateType")
    private OBInterestRateType1Code feeRateType = null;
    @JsonProperty(value="ApplicationFrequency")
    private OBFeeFrequency1Code applicationFrequency = null;
    @JsonProperty(value="CalculationFrequency")
    private OBFeeFrequency1Code calculationFrequency = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="OverdraftFeeChargeCap")
    @Valid
    private List<OBOverdraftFeeChargeCap1> overdraftFeeChargeCap = null;
    @JsonProperty(value="OtherFeeType")
    private OBOtherCodeType1 otherFeeType = null;
    @JsonProperty(value="OtherFeeRateType")
    private OBOtherCodeType1 otherFeeRateType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OBOtherCodeType1 otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OBOtherCodeType1 otherCalculationFrequency = null;

    public OBOverdraftFeesChargeDetails1 feeType(OBOverdraftFeeType1Code feeType) {
        this.feeType = feeType;
        return this;
    }

    @ApiModelProperty(required=true, value="Overdraft fee type")
    @NotNull
    public OBOverdraftFeeType1Code getFeeType() {
        return this.feeType;
    }

    public void setFeeType(OBOverdraftFeeType1Code feeType) {
        this.feeType = feeType;
    }

    public OBOverdraftFeesChargeDetails1 negotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether fee and charges are negotiable")
    public Boolean isNegotiableIndicator() {
        return this.negotiableIndicator;
    }

    public void setNegotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
    }

    public OBOverdraftFeesChargeDetails1 overdraftControlIndicator(Boolean overdraftControlIndicator) {
        this.overdraftControlIndicator = overdraftControlIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates if the fee/charge is already covered by an 'Overdraft Control' fee or not.")
    public Boolean isOverdraftControlIndicator() {
        return this.overdraftControlIndicator;
    }

    public void setOverdraftControlIndicator(Boolean overdraftControlIndicator) {
        this.overdraftControlIndicator = overdraftControlIndicator;
    }

    public OBOverdraftFeesChargeDetails1 incrementalBorrowingAmount(String incrementalBorrowingAmount) {
        this.incrementalBorrowingAmount = incrementalBorrowingAmount;
        return this;
    }

    @ApiModelProperty(value="Every additional tranche of an overdraft balance to which an overdraft fee is applied")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getIncrementalBorrowingAmount() {
        return this.incrementalBorrowingAmount;
    }

    public void setIncrementalBorrowingAmount(String incrementalBorrowingAmount) {
        this.incrementalBorrowingAmount = incrementalBorrowingAmount;
    }

    public OBOverdraftFeesChargeDetails1 feeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @ApiModelProperty(value="Amount charged for an overdraft fee/charge (where it is charged in terms of an amount rather than a rate)")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
    }

    public OBOverdraftFeesChargeDetails1 feeRate(String feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @ApiModelProperty(value="Rate charged for overdraft fee/charge (where it is charged in terms of a rate rather than an amount)")
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    public String getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(String feeRate) {
        this.feeRate = feeRate;
    }

    public OBOverdraftFeesChargeDetails1 feeRateType(OBInterestRateType1Code feeRateType) {
        this.feeRateType = feeRateType;
        return this;
    }

    @ApiModelProperty(value="Rate type for overdraft fee/charge (where it is charged in terms of a rate rather than an amount)")
    public OBInterestRateType1Code getFeeRateType() {
        return this.feeRateType;
    }

    public void setFeeRateType(OBInterestRateType1Code feeRateType) {
        this.feeRateType = feeRateType;
    }

    public OBOverdraftFeesChargeDetails1 applicationFrequency(OBFeeFrequency1Code applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @ApiModelProperty(required=true, value="Frequency at which the overdraft charge is applied to the account")
    @NotNull
    public OBFeeFrequency1Code getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(OBFeeFrequency1Code applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public OBOverdraftFeesChargeDetails1 calculationFrequency(OBFeeFrequency1Code calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How often is the overdraft fee/charge calculated for the account.")
    public OBFeeFrequency1Code getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(OBFeeFrequency1Code calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public OBOverdraftFeesChargeDetails1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBOverdraftFeesChargeDetails1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Free text for capturing any other info related to Overdraft Fees Charge Details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBOverdraftFeesChargeDetails1 overdraftFeeChargeCap(List<OBOverdraftFeeChargeCap1> overdraftFeeChargeCap) {
        this.overdraftFeeChargeCap = overdraftFeeChargeCap;
        return this;
    }

    public OBOverdraftFeesChargeDetails1 addOverdraftFeeChargeCapItem(OBOverdraftFeeChargeCap1 overdraftFeeChargeCapItem) {
        if (this.overdraftFeeChargeCap == null) {
            this.overdraftFeeChargeCap = new ArrayList<OBOverdraftFeeChargeCap1>();
        }
        this.overdraftFeeChargeCap.add(overdraftFeeChargeCapItem);
        return this;
    }

    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular fee/charge. Capping can either be based on an amount (in gbp), an amount (in items) or a rate.")
    @Valid
    public List<OBOverdraftFeeChargeCap1> getOverdraftFeeChargeCap() {
        return this.overdraftFeeChargeCap;
    }

    public void setOverdraftFeeChargeCap(List<OBOverdraftFeeChargeCap1> overdraftFeeChargeCap) {
        this.overdraftFeeChargeCap = overdraftFeeChargeCap;
    }

    public OBOverdraftFeesChargeDetails1 otherFeeType(OBOtherCodeType1 otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(OBOtherCodeType1 otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public OBOverdraftFeesChargeDetails1 otherFeeRateType(OBOtherCodeType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherFeeRateType() {
        return this.otherFeeRateType;
    }

    public void setOtherFeeRateType(OBOtherCodeType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
    }

    public OBOverdraftFeesChargeDetails1 otherApplicationFrequency(OBOtherCodeType1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OBOtherCodeType1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public OBOverdraftFeesChargeDetails1 otherCalculationFrequency(OBOtherCodeType1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OBOtherCodeType1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOverdraftFeesChargeDetails1 overdraft1OverdraftFeeChargeDetail = (OBOverdraftFeesChargeDetails1)o;
        return Objects.equals((Object)this.feeType, (Object)overdraft1OverdraftFeeChargeDetail.feeType) && Objects.equals(this.negotiableIndicator, overdraft1OverdraftFeeChargeDetail.negotiableIndicator) && Objects.equals(this.overdraftControlIndicator, overdraft1OverdraftFeeChargeDetail.overdraftControlIndicator) && Objects.equals(this.incrementalBorrowingAmount, overdraft1OverdraftFeeChargeDetail.incrementalBorrowingAmount) && Objects.equals(this.feeAmount, overdraft1OverdraftFeeChargeDetail.feeAmount) && Objects.equals(this.feeRate, overdraft1OverdraftFeeChargeDetail.feeRate) && Objects.equals((Object)this.feeRateType, (Object)overdraft1OverdraftFeeChargeDetail.feeRateType) && Objects.equals((Object)this.applicationFrequency, (Object)overdraft1OverdraftFeeChargeDetail.applicationFrequency) && Objects.equals((Object)this.calculationFrequency, (Object)overdraft1OverdraftFeeChargeDetail.calculationFrequency) && Objects.equals(this.notes, overdraft1OverdraftFeeChargeDetail.notes) && Objects.equals(this.overdraftFeeChargeCap, overdraft1OverdraftFeeChargeDetail.overdraftFeeChargeCap) && Objects.equals(this.otherFeeType, overdraft1OverdraftFeeChargeDetail.otherFeeType) && Objects.equals(this.otherFeeRateType, overdraft1OverdraftFeeChargeDetail.otherFeeRateType) && Objects.equals(this.otherApplicationFrequency, overdraft1OverdraftFeeChargeDetail.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, overdraft1OverdraftFeeChargeDetail.otherCalculationFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.negotiableIndicator, this.overdraftControlIndicator, this.incrementalBorrowingAmount, this.feeAmount, this.feeRate, this.feeRateType, this.applicationFrequency, this.calculationFrequency, this.notes, this.overdraftFeeChargeCap, this.otherFeeType, this.otherFeeRateType, this.otherApplicationFrequency, this.otherCalculationFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOverdraftFeesChargeDetails1 {\n");
        sb.append("    feeType: ").append(this.toIndentedString((Object)this.feeType)).append("\n");
        sb.append("    negotiableIndicator: ").append(this.toIndentedString(this.negotiableIndicator)).append("\n");
        sb.append("    overdraftControlIndicator: ").append(this.toIndentedString(this.overdraftControlIndicator)).append("\n");
        sb.append("    incrementalBorrowingAmount: ").append(this.toIndentedString(this.incrementalBorrowingAmount)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    feeRateType: ").append(this.toIndentedString((Object)this.feeRateType)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftFeeChargeCap: ").append(this.toIndentedString(this.overdraftFeeChargeCap)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("    otherFeeRateType: ").append(this.toIndentedString(this.otherFeeRateType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

