/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBOverdraftFeesCharges1;
import uk.org.openbanking.datamodel.account.OBOverdraftTierBand1;
import uk.org.openbanking.datamodel.account.OBOverdraftType1Code;
import uk.org.openbanking.datamodel.account.OBTierBandType1Code;

@ApiModel(description="Tier band set details")
@Validated
public class OBOverdraftTierbandSet1 {
    @JsonProperty(value="TierBandMethod")
    private OBTierBandType1Code tierBandMethod = null;
    @JsonProperty(value="OverdraftType")
    private OBOverdraftType1Code overdraftType = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="AuthorisedIndicator")
    private Boolean authorisedIndicator = null;
    @JsonProperty(value="BufferAmount")
    private String bufferAmount = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="OverdraftTierBand")
    @Valid
    private List<OBOverdraftTierBand1> overdraftTierBand = new ArrayList<OBOverdraftTierBand1>();
    @JsonProperty(value="OverdraftFeesCharges")
    @Valid
    private List<OBOverdraftFeesCharges1> overdraftFeesCharges = null;

    public OBOverdraftTierbandSet1 tierBandMethod(OBTierBandType1Code tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="The methodology of how overdraft is charged. It can be: 'Whole'  Where the same charge/rate is applied to the entirety of the overdraft balance (where charges are applicable).  'Tiered' Where different charges/rates are applied dependent on overdraft maximum and minimum balance amount tiers defined by the lending financial organisation 'Banded' Where different charges/rates are applied dependent on overdraft maximum and minimum balance amount bands defined by a government organisation.")
    @NotNull
    public OBTierBandType1Code getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(OBTierBandType1Code tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public OBOverdraftTierbandSet1 overdraftType(OBOverdraftType1Code overdraftType) {
        this.overdraftType = overdraftType;
        return this;
    }

    @ApiModelProperty(value="An overdraft can either be 'committed' which means that the facility cannot be withdrawn without reasonable notification before it's agreed end date, or 'on demand' which means that the financial institution can demand repayment at any point in time.")
    public OBOverdraftType1Code getOverdraftType() {
        return this.overdraftType;
    }

    public void setOverdraftType(OBOverdraftType1Code overdraftType) {
        this.overdraftType = overdraftType;
    }

    public OBOverdraftTierbandSet1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a overdraft product.")
    @Size(min=1, max=35)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBOverdraftTierbandSet1 authorisedIndicator(Boolean authorisedIndicator) {
        this.authorisedIndicator = authorisedIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates if the Overdraft is authorised (Y) or unauthorised (N)")
    public Boolean isAuthorisedIndicator() {
        return this.authorisedIndicator;
    }

    public void setAuthorisedIndicator(Boolean authorisedIndicator) {
        this.authorisedIndicator = authorisedIndicator;
    }

    public OBOverdraftTierbandSet1 bufferAmount(String bufferAmount) {
        this.bufferAmount = bufferAmount;
        return this;
    }

    @ApiModelProperty(value="When a customer exceeds their credit limit, a financial institution will not charge the customer unauthorised overdraft charges if they do not exceed by more than the buffer amount. Note: Authorised overdraft charges may still apply.")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getBufferAmount() {
        return this.bufferAmount;
    }

    public void setBufferAmount(String bufferAmount) {
        this.bufferAmount = bufferAmount;
    }

    public OBOverdraftTierbandSet1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBOverdraftTierbandSet1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the overdraft Tier Band Set details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBOverdraftTierbandSet1 overdraftTierBand(List<OBOverdraftTierBand1> overdraftTierBand) {
        this.overdraftTierBand = overdraftTierBand;
        return this;
    }

    public OBOverdraftTierbandSet1 addOverdraftTierBandItem(OBOverdraftTierBand1 overdraftTierBandItem) {
        this.overdraftTierBand.add(overdraftTierBandItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Provides overdraft details for a specific tier or band")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBOverdraftTierBand1> getOverdraftTierBand() {
        return this.overdraftTierBand;
    }

    public void setOverdraftTierBand(List<OBOverdraftTierBand1> overdraftTierBand) {
        this.overdraftTierBand = overdraftTierBand;
    }

    public OBOverdraftTierbandSet1 overdraftFeesCharges(List<OBOverdraftFeesCharges1> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
        return this;
    }

    public OBOverdraftTierbandSet1 addOverdraftFeesChargesItem(OBOverdraftFeesCharges1 overdraftFeesChargesItem) {
        if (this.overdraftFeesCharges == null) {
            this.overdraftFeesCharges = new ArrayList<OBOverdraftFeesCharges1>();
        }
        this.overdraftFeesCharges.add(overdraftFeesChargesItem);
        return this;
    }

    @ApiModelProperty(value="Overdraft fees and charges details")
    @Valid
    public List<OBOverdraftFeesCharges1> getOverdraftFeesCharges() {
        return this.overdraftFeesCharges;
    }

    public void setOverdraftFeesCharges(List<OBOverdraftFeesCharges1> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOverdraftTierbandSet1 overdraft1OverdraftTierBandSet = (OBOverdraftTierbandSet1)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)overdraft1OverdraftTierBandSet.tierBandMethod) && Objects.equals((Object)this.overdraftType, (Object)overdraft1OverdraftTierBandSet.overdraftType) && Objects.equals(this.identification, overdraft1OverdraftTierBandSet.identification) && Objects.equals(this.authorisedIndicator, overdraft1OverdraftTierBandSet.authorisedIndicator) && Objects.equals(this.bufferAmount, overdraft1OverdraftTierBandSet.bufferAmount) && Objects.equals(this.notes, overdraft1OverdraftTierBandSet.notes) && Objects.equals(this.overdraftTierBand, overdraft1OverdraftTierBandSet.overdraftTierBand) && Objects.equals(this.overdraftFeesCharges, overdraft1OverdraftTierBandSet.overdraftFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.overdraftType, this.identification, this.authorisedIndicator, this.bufferAmount, this.notes, this.overdraftTierBand, this.overdraftFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOverdraftTierbandSet1 {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    overdraftType: ").append(this.toIndentedString((Object)this.overdraftType)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    authorisedIndicator: ").append(this.toIndentedString(this.authorisedIndicator)).append("\n");
        sb.append("    bufferAmount: ").append(this.toIndentedString(this.bufferAmount)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftTierBand: ").append(this.toIndentedString(this.overdraftTierBand)).append("\n");
        sb.append("    overdraftFeesCharges: ").append(this.toIndentedString(this.overdraftFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

