/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBPCAProductSegment1Code;

@Validated
public class OBPCAProductDetails1 {
    @JsonProperty(value="Segment")
    @Valid
    private List<OBPCAProductSegment1Code> segment = null;
    @JsonProperty(value="MonthlyMaximumCharge")
    private String monthlyMaximumCharge = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;

    public OBPCAProductDetails1 segment(List<OBPCAProductSegment1Code> segment) {
        this.segment = segment;
        return this;
    }

    public OBPCAProductDetails1 addSegmentItem(OBPCAProductSegment1Code segmentItem) {
        if (this.segment == null) {
            this.segment = new ArrayList<OBPCAProductSegment1Code>();
        }
        this.segment.add(segmentItem);
        return this;
    }

    @ApiModelProperty(value="Market segmentation is a marketing term referring to the aggregating of prospective buyers into groups, or segments, that have common needs and respond similarly to a marketing action. Market segmentation enables companies to target different categories of consumers who perceive the full value of certain products and services differently from one another.  Read more: Market Segmentation http://www.investopedia.com/terms/m/marketsegmentation.asp#ixzz4gfEEalTd  With respect to PCA products, they are segmented in relation to different markets that they wish to focus on. ")
    public List<OBPCAProductSegment1Code> getSegment() {
        return this.segment;
    }

    public void setSegment(List<OBPCAProductSegment1Code> segment) {
        this.segment = segment;
    }

    public OBPCAProductDetails1 monthlyMaximumCharge(String monthlyMaximumCharge) {
        this.monthlyMaximumCharge = monthlyMaximumCharge;
        return this;
    }

    @ApiModelProperty(value="The maximum relevant charges that could accrue as defined fully in Part 7 of the CMA order")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getMonthlyMaximumCharge() {
        return this.monthlyMaximumCharge;
    }

    public void setMonthlyMaximumCharge(String monthlyMaximumCharge) {
        this.monthlyMaximumCharge = monthlyMaximumCharge;
    }

    public OBPCAProductDetails1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBPCAProductDetails1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Core product details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBPCAProductDetails1 productDetails = (OBPCAProductDetails1)o;
        return Objects.equals(this.segment, productDetails.segment) && Objects.equals(this.monthlyMaximumCharge, productDetails.monthlyMaximumCharge) && Objects.equals(this.notes, productDetails.notes);
    }

    public int hashCode() {
        return Objects.hash(this.segment, this.monthlyMaximumCharge, this.notes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBPCAProductDetails1 {\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    monthlyMaximumCharge: ").append(this.toIndentedString(this.monthlyMaximumCharge)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

