/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBExternalProductType1Code;

@ApiModel(description="Product")
public class OBProduct1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="ProductIdentifier")
    private String productIdentifier = null;
    @JsonProperty(value="ProductType")
    private OBExternalProductType1Code productType = null;
    @JsonProperty(value="ProductName")
    private String productName = null;
    @JsonProperty(value="SecondaryProductIdentifier")
    private String secondaryProductIdentifier = null;

    public OBProduct1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique and immutable identifier used to identify the account resource. This identifier has no meaning to the account owner.")
    @NotNull
    @Size(min=1, max=40)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBProduct1 productIdentifier(String productIdentifier) {
        this.productIdentifier = productIdentifier;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier within the parent organisation for the product. Must be unique in the organisation.")
    @NotNull
    public String getProductIdentifier() {
        return this.productIdentifier;
    }

    public void setProductIdentifier(String productIdentifier) {
        this.productIdentifier = productIdentifier;
    }

    public OBProduct1 productType(OBExternalProductType1Code productType) {
        this.productType = productType;
        return this;
    }

    @ApiModelProperty(required=true, value="Descriptive code for the product category.")
    @NotNull
    public OBExternalProductType1Code getProductType() {
        return this.productType;
    }

    public void setProductType(OBExternalProductType1Code productType) {
        this.productType = productType;
    }

    public OBProduct1 productName(String productName) {
        this.productName = productName;
        return this;
    }

    @ApiModelProperty(value="The name of the product used for marketing purposes from a customer perspective. I.e. what the customer would recognise.")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public OBProduct1 secondaryProductIdentifier(String secondaryProductIdentifier) {
        this.secondaryProductIdentifier = secondaryProductIdentifier;
        return this;
    }

    @ApiModelProperty(value="Identifier within the parent organisation for the product. Must be unique in the organisation.")
    public String getSecondaryProductIdentifier() {
        return this.secondaryProductIdentifier;
    }

    public void setSecondaryProductIdentifier(String secondaryProductIdentifier) {
        this.secondaryProductIdentifier = secondaryProductIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBProduct1 product = (OBProduct1)o;
        return Objects.equals(this.accountId, product.accountId) && Objects.equals(this.productIdentifier, product.productIdentifier) && Objects.equals((Object)this.productType, (Object)product.productType) && Objects.equals(this.productName, product.productName) && Objects.equals(this.secondaryProductIdentifier, product.secondaryProductIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.productIdentifier, this.productType, this.productName, this.secondaryProductIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Product {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    productIdentifier: ").append(this.toIndentedString(this.productIdentifier)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    secondaryProductIdentifier: ").append(this.toIndentedString(this.secondaryProductIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

