/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBCAData1;
import uk.org.openbanking.datamodel.account.OBExternalProductType2Code;
import uk.org.openbanking.datamodel.account.OBOtherProductType1;
import uk.org.openbanking.datamodel.account.OBPCAData1;

@Validated
public class OBProduct2 {
    @JsonProperty(value="ProductName")
    private String productName = null;
    @JsonProperty(value="ProductId")
    private String productId = null;
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="SecondaryProductId")
    private String secondaryProductId = null;
    @JsonProperty(value="ProductType")
    private OBExternalProductType2Code productType = null;
    @JsonProperty(value="MarketingStateId")
    private String marketingStateId = null;
    @JsonProperty(value="OtherProductType")
    private OBOtherProductType1 otherProductType = null;
    @JsonProperty(value="BCA")
    private OBBCAData1 bca = null;
    @JsonProperty(value="PCA")
    private OBPCAData1 pca = null;

    public OBProduct2 productName(String productName) {
        this.productName = productName;
        return this;
    }

    @ApiModelProperty(value="The name of the product used for marketing purposes from a customer perspective. I.e. what the customer would recognise.")
    @Size(min=1, max=350)
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public OBProduct2 productId(String productId) {
        this.productId = productId;
        return this;
    }

    @ApiModelProperty(value="Identifier within the parent organisation for the product. Must be unique in the organisation.")
    @Size(min=1, max=40)
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public OBProduct2 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBProduct2 secondaryProductId(String secondaryProductId) {
        this.secondaryProductId = secondaryProductId;
        return this;
    }

    @ApiModelProperty(value="Identifier within the parent organisation for the product. Must be unique in the organisation.")
    @Size(min=1, max=70)
    public String getSecondaryProductId() {
        return this.secondaryProductId;
    }

    public void setSecondaryProductId(String secondaryProductId) {
        this.secondaryProductId = secondaryProductId;
    }

    public OBProduct2 productType(OBExternalProductType2Code productType) {
        this.productType = productType;
        return this;
    }

    @ApiModelProperty(value="")
    @NotNull
    @Valid
    public OBExternalProductType2Code getProductType() {
        return this.productType;
    }

    public void setProductType(OBExternalProductType2Code productType) {
        this.productType = productType;
    }

    public OBProduct2 marketingStateId(String marketingStateId) {
        this.marketingStateId = marketingStateId;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous identification of a Product Marketing State.")
    @Size(min=1, max=35)
    public String getMarketingStateId() {
        return this.marketingStateId;
    }

    public void setMarketingStateId(String marketingStateId) {
        this.marketingStateId = marketingStateId;
    }

    public OBProduct2 otherProductType(OBOtherProductType1 otherProductType) {
        this.otherProductType = otherProductType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherProductType1 getOtherProductType() {
        return this.otherProductType;
    }

    public void setOtherProductType(OBOtherProductType1 otherProductType) {
        this.otherProductType = otherProductType;
    }

    public OBProduct2 bca(OBBCAData1 bca) {
        this.bca = bca;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBCAData1 getBca() {
        return this.bca;
    }

    public void setBca(OBBCAData1 bca) {
        this.bca = bca;
    }

    public OBProduct2 pca(OBPCAData1 pca) {
        this.pca = pca;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPCAData1 getPca() {
        return this.pca;
    }

    public void setPca(OBPCAData1 pca) {
        this.pca = pca;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBProduct2 obProduct2 = (OBProduct2)o;
        return Objects.equals(this.productName, obProduct2.productName) && Objects.equals(this.productId, obProduct2.productId) && Objects.equals(this.accountId, obProduct2.accountId) && Objects.equals(this.secondaryProductId, obProduct2.secondaryProductId) && Objects.equals((Object)this.productType, (Object)obProduct2.productType) && Objects.equals(this.marketingStateId, obProduct2.marketingStateId) && Objects.equals(this.otherProductType, obProduct2.otherProductType) && Objects.equals(this.bca, obProduct2.bca) && Objects.equals(this.pca, obProduct2.pca);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productName, this.productId, this.accountId, this.secondaryProductId, this.productType, this.marketingStateId, this.otherProductType, this.bca, this.pca});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBProduct2 {\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    secondaryProductId: ").append(this.toIndentedString(this.secondaryProductId)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    marketingStateId: ").append(this.toIndentedString(this.marketingStateId)).append("\n");
        sb.append("    otherProductType: ").append(this.toIndentedString(this.otherProductType)).append("\n");
        sb.append("    BCA: ").append(this.toIndentedString(this.bca)).append("\n");
        sb.append("    PCA: ").append(this.toIndentedString(this.pca)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

