/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import uk.org.openbanking.datamodel.account.OBReadBalance1DataAmount1;

@ApiModel(description="Set of elements used to provide details on the credit line.")
public class OBReadBalance1DataCreditLine {
    @JsonProperty(value="Included")
    private Boolean included = null;
    @JsonProperty(value="Type")
    private TypeEnum type = null;
    @JsonProperty(value="Amount")
    private OBReadBalance1DataAmount1 amount = null;

    public OBReadBalance1DataCreditLine included(Boolean included) {
        this.included = included;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Indicates whether or not the credit line is included in the balance of the account. Usage: If not present, credit line is not included in the balance amount of the account.")
    public Boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(Boolean included) {
        this.included = included;
    }

    public OBReadBalance1DataCreditLine type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Limit type, in a coded form.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OBReadBalance1DataCreditLine amount(OBReadBalance1DataAmount1 amount) {
        this.amount = amount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadBalance1DataAmount1 getAmount() {
        return this.amount;
    }

    public void setAmount(OBReadBalance1DataAmount1 amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadBalance1DataCreditLine obReadBalance1DataCreditLine = (OBReadBalance1DataCreditLine)o;
        return Objects.equals(this.included, obReadBalance1DataCreditLine.included) && Objects.equals((Object)this.type, (Object)obReadBalance1DataCreditLine.type) && Objects.equals(this.amount, obReadBalance1DataCreditLine.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.included, this.type, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadBalance1DataCreditLine {\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        AVAILABLE("Available"),
        CREDIT("Credit"),
        EMERGENCY("Emergency"),
        PRE_AGREED("Pre-Agreed"),
        TEMPORARY("Temporary");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

