/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalPermissions1Code;
import uk.org.openbanking.datamodel.account.OBExternalRequestStatus1Code;

@Validated
public class OBReadConsentResponse1Data {
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private OBExternalRequestStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="Permissions")
    @Valid
    private List<OBExternalPermissions1Code> permissions = new ArrayList<OBExternalPermissions1Code>();
    @JsonProperty(value="ExpirationDateTime")
    private DateTime expirationDateTime = null;
    @JsonProperty(value="TransactionFromDateTime")
    private DateTime transactionFromDateTime = null;
    @JsonProperty(value="TransactionToDateTime")
    private DateTime transactionToDateTime = null;

    public OBReadConsentResponse1Data consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification as assigned to identify the account access consent resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBReadConsentResponse1Data creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBReadConsentResponse1Data status(OBExternalRequestStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalRequestStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalRequestStatus1Code status) {
        this.status = status;
    }

    public OBReadConsentResponse1Data statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBReadConsentResponse1Data permissions(List<OBExternalPermissions1Code> permissions) {
        this.permissions = permissions;
        return this;
    }

    public OBReadConsentResponse1Data addPermissionsItem(OBExternalPermissions1Code permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the Open Banking account access data types. This is a list of the data clusters being consented by the PSU, and requested for authorisation with the ASPSP.")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBExternalPermissions1Code> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<OBExternalPermissions1Code> permissions) {
        this.permissions = permissions;
    }

    public OBReadConsentResponse1Data expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified date and time the permissions will expire. If this is not populated, the permissions will be open ended. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public OBReadConsentResponse1Data transactionFromDateTime(DateTime transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified start date and time for the transaction query period. If this is not populated, the start date will be open ended, and data will be returned from the earliest available transaction. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getTransactionFromDateTime() {
        return this.transactionFromDateTime;
    }

    public void setTransactionFromDateTime(DateTime transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
    }

    public OBReadConsentResponse1Data transactionToDateTime(DateTime transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified end date and time for the transaction query period. If this is not populated, the end date will be open ended, and data will be returned to the latest available transaction. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getTransactionToDateTime() {
        return this.transactionToDateTime;
    }

    public void setTransactionToDateTime(DateTime transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadConsentResponse1Data obReadConsentResponse1Data = (OBReadConsentResponse1Data)o;
        return Objects.equals(this.consentId, obReadConsentResponse1Data.consentId) && Objects.equals(this.creationDateTime, obReadConsentResponse1Data.creationDateTime) && Objects.equals((Object)this.status, (Object)obReadConsentResponse1Data.status) && Objects.equals(this.statusUpdateDateTime, obReadConsentResponse1Data.statusUpdateDateTime) && Objects.equals(this.permissions, obReadConsentResponse1Data.permissions) && Objects.equals(this.expirationDateTime, obReadConsentResponse1Data.expirationDateTime) && Objects.equals(this.transactionFromDateTime, obReadConsentResponse1Data.transactionFromDateTime) && Objects.equals(this.transactionToDateTime, obReadConsentResponse1Data.transactionToDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.permissions, this.expirationDateTime, this.transactionFromDateTime, this.transactionToDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadConsentResponse1Data {\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("    transactionFromDateTime: ").append(this.toIndentedString(this.transactionFromDateTime)).append("\n");
        sb.append("    transactionToDateTime: ").append(this.toIndentedString(this.transactionToDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

